from django.test import TestCase

from libs.region import Graph
from libs.testcase import DorisTestCase
from recommend.utils.service import get_hot_service_by_tags


class RecommandTestCase(DorisTestCase):
    def test_recommend_service(self):
        params = {
            "device_id": "aaa"
        }
        resp = self.call("dymas/recommend/service", params)
        self.assertEqual(resp.code, 0)

    def test_get_hot_service_by_tags(self):
        services = get_hot_service_by_tags([2, 23, 992], 259)

    def test_get_recommend_interest_tag(self):
        params = {
            "device_id": "aaa"
        }
        resp = self.call("dymas/recommend/interest_tag", params)

    def test_tobuy_service(self):
        params = {
            "device_id": "56D5E838-470E-42BB-87E1-FA07C47FC390"
        }
        resp = self.call("dymas/willbuy/service", params)
        self.assertEqual(resp.code, 0)


class RegionGraphTestCase(TestCase):
    def test_region_graph(self):
        """

        :return:
        """
        g = Graph.buildGraph()
        self.assertTrue(g.isNearBy("beijing", "tianjin"))
        self.assertTrue(g.isNearBy("beijing", "shijiazhuang"))
        self.assertTrue(g.isNearBy("tianjin", "beijing"))
        self.assertTrue(g.isNearBy("tianjin", "shijiazhuang"))
        self.assertTrue(g.isNearBy("taiwan", "xiamen"))
        self.assertTrue(g.isNearBy("aomen", "shenzhen"))

        self.assertFalse(g.isNearBy("beijing", "beijing"))
        self.assertFalse(g.isNearBy("beijing", "zhengzhou"))
        self.assertFalse(g.isNearBy("tianjin", "zhengzhou"))
        self.assertFalse(g.isNearBy("zhengzhou", "chongqing"))
