"""
__author__ = 'xumingming'
"""
from gm_types.gaia import DIARY_ORDER_TYPE
from libs.rpc import get_rpc_invoker
import logging

logger = logging.getLogger(__name__)


class RealtimeFilter(object):
    def __get__(self, instance, owner):
        if not instance:
            return self

        filter_result = self.realtime_filter_recall(instance.recall_)

        logger.info('origin ids : {}, delete ids : {}, result ids :{}'.format(
            instance.recall_,
            [id for id in instance.recall_ if id not in filter_result],
            filter_result
        ))

        instance.recall_ = filter_result

    def realtime_filter_recall(self, recall):
        raise NotImplementedError


class DiaryRealtimeFilter(RealtimeFilter):
    def __init__(self):
        self.es_type = 'diary'
        self.es_sort_type = DIARY_ORDER_TYPE.FEED_FILTER

    def realtime_filter_recall(self, recall):
        r = get_rpc_invoker()
        return r["search/diary/esquery_feed"](ids=recall).unwrap()
