class DatabaseRouter(object):
    """ Mimas router. Change all question-answer related operation to mimas.
    """
    PREFIX = 'extend.models.{}'

    def checkObjOrigin(self, obj):
        if obj.__module__.startswith(self.PREFIX.format("gaia")):
            return "gaia"
        elif obj.__module__.startswith(self.PREFIX.format("mimas")):
            return "mimas"

        elif obj._meta.app_label == 'gaia':
            return 'gaia'

        return None

    def db_for_read(self, model, **hints):
        return self.checkObjOrigin(model)

    def db_for_write(self, model, **hints):
        return self.checkObjOrigin(model)

    def allow_relation(self, obj1, obj2, **hints):
        return None

    def allow_migrate(self, db, app_label, model_name=None, **hints):
        return None
