from django.shortcuts import render
from gm_rpcd.all import bind, RPCDFaultException
from gm_types.doris import STRATEGY_TYPE
from rank.models import Strategy
from libs.error import raise_error
from gm_types.doris.error import ERROR
# Create your views here.

ALLOW_STRATEGY = [
    STRATEGY_TYPE.SERVICE_SEARCH,
    STRATEGY_TYPE.DOCTOR_ORDER
]


@bind('doris/strategy/get')
def get_doris_strategy(strategy_name=None):
    if strategy_name is None:
        return {}
    elif strategy_name not in ALLOW_STRATEGY:
        raise_error(ERROR.UNSUPPORT_STRATEGY_TYPE)
    else:
        return Strategy.get_strategy(strategy_name)
