import json

from django.core.management.base import BaseCommand
from recommend.models import ServiceHot
from libs.cache import redis_client

class Command(BaseCommand):
    def handle(self, *args, **options):
        hotitems = ServiceHot.objects.values("service_id").distinct()
        for hotitem in hotitems:
            service_id = hotitem.get("service_id")
            service_items = ServiceHot.objects.filter(service_id=service_id)
            tag_heat = []
            for service in service_items:
                tag_heat.append({
                    "tag_id":service.tag_id,
                    "heat_score":service.rank
                })
            print(tag_heat)
            cache_data = {
                "tag_heat":tag_heat
            }
            redis_key = ServiceHot.get_stat_key(service_id)
            redis_client.set(redis_key,json.dumps(cache_data))


