import datetime
import time

import tensorflow as tf

from models.esmm.fe import (get_device_dict_from_redis, get_diary_dict_from_redis)
from models.esmm.model import model_predict_diary
from utils.cache import redis_client2
from utils.portrait import (user_portrait_tag3_get_candidate_unread_list, user_portrait_tag3_write_ctcvr_data)


def user_portrait_scan_info():
    try:
        round = 0
        all_count = 0
        keys = "doris:user_portrait:tag3:device_id:*"
        cur, results = redis_client2.scan(0, keys, 3000)
        while cur != 0:
            round += 1
            print("round: " + str(round))
            cur, results = redis_client2.scan(cur, keys, 3000)
            for key in results:
                key = str(key, "utf-8")
                device_id = key.split(":")[-1]
                print(device_id)
                print(user_portrait_tag3_get_candidate_unread_list(device_id, "diary")[:10])
                all_count += 1

        print("all count: " + str(all_count))
        print("scan done " + str(datetime.datetime.now()))
    except Exception as e:
        print(e)


def main():
    time_begin = time.time()
    tf.logging.set_verbosity(tf.compat.v1.logging.INFO)

    device_dict = get_device_dict_from_redis()
    diary_dict = get_diary_dict_from_redis()

    device_id = "androidid_a25a1129c0b38f7b"
    save_path = "/home/gmuser/data/models/1595501144"
    predict_fn = tf.contrib.predictor.from_saved_model(save_path)

    diary_ids = user_portrait_tag3_get_candidate_unread_list(device_id, "diary")
    model_predict_diary(device_id, diary_ids, device_dict, diary_dict, predict_fn)
    # user_portrait_scan_info()

    total_time = (time.time() - time_begin) / 60
    print("total cost {:.2f} mins at {}".format(total_time, datetime.now()))


if __name__ == "__main__":
    main()
