import tensorflow as tf
from tensorflow import feature_column as fc

from ..utils import create_boundaries, create_vocabulary_list


def build_features(df, int_columns, float_columns, categorical_columns):
    numeric_features = []
    for col in (int_columns + float_columns):
        if col in int_columns:
            numeric_features.append(
                fc.bucketized_column(fc.numeric_column(col, dtype=tf.int64), boundaries=create_boundaries(df, col)))
        else:
            numeric_features.append(fc.bucketized_column(fc.numeric_column(col), boundaries=create_boundaries(df, col)))

    categorical_features = []
    for col in categorical_columns:
        if col == "card_id":
            categorical_features.append(
                fc.embedding_column(fc.categorical_column_with_hash_bucket(col, 20000, dtype=tf.int64),
                                    dimension=int(df[col].size**0.25)))
        elif col == "device_id":
            categorical_features.append(
                fc.embedding_column(fc.categorical_column_with_hash_bucket(col, 400000), dimension=int(df[col].size**0.25)))
        elif col == "show_tag_id":
            categorical_features.append(
                fc.embedding_column(fc.categorical_column_with_hash_bucket(col, 100000), dimension=int(df[col].size**0.25)))
        else:
            categorical_features.append(
                fc.indicator_column(fc.categorical_column_with_vocabulary_list(col, create_vocabulary_list(df, col))))

    all_features = (numeric_features + categorical_features)
    return all_features
