import pandas as pd


def click_feature_engineering(click_df, conversion_df):
    # click_df = click_df.copy()
    # conversion_df = conversion_df.copy()

    click_df.rename(columns={"label": "click_label"}, inplace=True)
    conversion_df.rename(columns={"label": "conversion_label"}, inplace=True)
    cc_df = pd.merge(click_df, conversion_df, how="left", left_on=["cl_id", "card_id"], right_on=["cl_id", "card_id"])
    cc_df.drop(["partition_date_x", "partition_date_y"], axis=1, inplace=True)
    cc_df["conversion_label"].fillna(0, inplace=True)

    print("click:")
    nullseries = cc_df.isnull().sum()
    print(nullseries[nullseries > 0])
    print(cc_df.shape)

    return cc_df
