import datetime
import time

from pathlib import Path
from sklearn.model_selection import train_test_split

from models.esmm.fe import device_fe as device_fe
from models.esmm.fe import tractate_fe as tractate_fe
from models.esmm.fe import click_fe as click_fe


def main():
    time_begin = time.time()

    data_path = Path("~/data/cvr_data").expanduser()  # local
    # data_path = Path("/srv/apps/node2vec_git/cvr_data/")  # server
    tractate_df, tractate_click_df, tractate_conversion_df = tractate_fe.read_csv_data(data_path)
    device_df = device_fe.read_csv_data(data_path)

    total_time = (time.time() - time_begin) / 60
    print("total cost {:.2f} mins at {}".format(total_time, datetime.now()))


if __name__ == "__main__":
    main()
