import datetime
import time

import tensorflow as tf

from models.esmm.fe import device_fe, diary_fe, tractate_fe
from models.esmm.tractate_model import model_predict_tractate
from utils.cache import redis_client2
from utils.grey import recommed_service_category_device_id_by_tail
from utils.portrait import (get_user_portrait_tag3_read_v2, user_portrait_tag3_get_candidate_dict,
                            user_portrait_tag3_get_candidate_unread_list, user_portrait_tag3_write_ctcvr_data)

if __name__ == "__main__":
    time_begin = time.time()

    device_dict = device_fe.get_device_dict_from_redis()
    tractate_dict = tractate_fe.get_tractate_dict_from_redis()
    print("redis data: " + str(len(device_dict)) + " " + str(len(tractate_dict)))

    device_id = "androidid_a25a1129c0b38f7b"

    tractate_save_path = "/home/gmuser/data/models/tractate/1596092061"
    tractate_predict_fn = tf.contrib.predictor.from_saved_model(tractate_save_path)

    tractate_ids = user_portrait_tag3_get_candidate_unread_list(device_id, "tractate")
    print("tractate_ids: " + str(len(tractate_ids)))
    res = model_predict_tractate(device_id, tractate_ids, device_dict, tractate_dict, tractate_predict_fn)
    print("res: " + str(len(res)))
    print(res[:10])
    # user_portrait_tag3_write_ctcvr_data(device_id, "tractate", res[:500])

    total_time = (time.time() - time_begin) / 60
    print("total cost {:.2f} mins at {}".format(total_time, datetime.datetime.now()))
