from datetime import datetime

import tensorflow as tf

from main_portrait import offline_predict_diary, offline_predict_tractate
from models.esmm.fe import device_fe, diary_fe, tractate_fe
from utils.cache import get_essm_model_save_path, redis_client4


def predict_with_city_changed(device_dict, diary_dict, tractate_dict, diary_predict_fn, tractate_predict_fn):
    key = "doris:user_portrait:city_changed:device:queue"

    try:
        total = redis_client4.llen(key)
        if (total > 0):
            device_id = redis_client4.lpop(key)
            device_id = str(device_id, "utf-8")
            print(device_id + " " + str(datetime.now()))
            offline_predict_diary(device_id, device_dict, diary_dict, diary_predict_fn)
            print("---------------------")
            offline_predict_tractate(device_id, device_dict, tractate_dict, tractate_predict_fn)
            print("=========================================\n")
    except Exception as e:
        print(e)


if __name__ == "__main__":
    tf.compat.v1.logging.set_verbosity(tf.compat.v1.logging.INFO)

    device_dict = device_fe.get_device_dict_from_redis()
    diary_dict = diary_fe.get_diary_dict_from_redis()
    tractate_dict = tractate_fe.get_tractate_dict_from_redis()
    print("redis data: " + str(len(device_dict)) + " " + str(len(diary_dict)) + " " + str(len(tractate_dict)))

    diary_save_path = get_essm_model_save_path("diary")
    if not diary_save_path:
        diary_save_path = "/data/files/models/diary/1597390452"
        print(diary_save_path + "!!!!!!!!!!!!!!!!!!!!!!!!!!!")
    diary_predict_fn = tf.contrib.predictor.from_saved_model(diary_save_path)

    tractate_save_path = get_essm_model_save_path("tractate")
    if not tractate_save_path:
        tractate_save_path = "/data/files/models/tractate/1597390051"
        print(tractate_save_path + "!!!!!!!!!!!!!!!!!!!!!!!!!!!")
    tractate_predict_fn = tf.contrib.predictor.from_saved_model(tractate_save_path)

    while True:
        predict_with_city_changed(device_dict, diary_dict, tractate_dict, diary_predict_fn, tractate_predict_fn)
