import datetime
import json
import random
from itertools import chain, zip_longest

from .cache import redis_client2, redis_client4


# merge_lists([1, 2], [3, 5, 6, 7], [4])
# [1, 3, 4, 2, 5, 6, 7]
def merge_lists(*lol):
    a = zip_longest(*lol)
    return [i for i in chain(*a) if i is not None]


def get_n_unread_data_from_ids(data, size, read_lst):
    """
    data: ['852170', '864084', '231589']
    """
    res = []
    for id_str in data:
        id = int(id_str)
        if len(res) >= size:
            break
        elif (id not in set(read_lst)) and (id not in res):
            res.append(id)
    return res


# 获取前1天或N天的日期，beforeOfDay=1：前1天；beforeOfDay=N：前N天
def getdate(beforeOfDay):
    today = datetime.datetime.now()
    # 计算偏移量
    offset = datetime.timedelta(days=-beforeOfDay)
    # 获取想要的日期的时间
    re_date = (today + offset).strftime("%Y-%m-%d")
    return re_date


def get_before_5_days_date():
    return [getdate(i) for i in range(5)]


def remove_read_with_size(lol, content_type, read_list, size=500):
    """
    content_type: diary, tractate, answer
    diary, tractate: [[15358970, 16999710, 16569184, 16457012, 16424738], [17213175, 17203529, 16196387, 15597816, 16715016]]
    answer [[['78937', 25449], ['50691', 19437]], [['78937', 25449], ['50691', 19437]]]
    """
    read = set(read_list)
    res = []
    for i in lol:
        tmp = []
        if (content_type in ["diary", "tractate"]):
            for id in i:
                if len(tmp) >= size:
                    break
                if id not in read:
                    tmp.append(id)
            res.append(tmp)
        else:
            for (id_str, question_id) in i:
                id = int(id_str)
                if len(tmp) >= size:
                    break
                if id not in read:
                    tmp.append([id_str, question_id])
            res.append(tmp)
    return res


def get_n_unread_data_from_ids(data, size, read_lst):
    """
    data: ['852170', '864084', '231589']
    """
    res = []
    for id_str in data:
        id = int(id_str)
        if len(res) >= size:
            break
        elif (id not in set(read_lst)) and (id not in res):
            res.append(id)
    return res


def _user_portrait_tag3_get_ctcvr_candidate_key(device_id, content_type):
    """
    device_id:
    content_type: diary
    return:
    """
    return "doris:user_portrait:tag3:ctcvr:candidate:{}:device_id:".format(content_type) + str(device_id)


def _user_portrait_tag3_get_candidate_key(device_id, content_type, latest=False):
    """
    content_type: diary, tractate, answer
    """
    key = "doris:user_portrait:tag3:candidate:{}:device_id:".format(content_type) + str(device_id)
    if latest:
        key = "doris:user_portrait:tag3:candidate_latest:{}:device_id:".format(content_type) + str(device_id)
    return key


def _get_user_portrait_tag3_read_key_v2(device_id, content_type):
    return "doris:user_portrait:tag3:read_v2:device_id:{}:content_type:{}".format(device_id, content_type)


def get_user_portrait_tag3_read_v2(device_id, content_type):
    key = _get_user_portrait_tag3_read_key_v2(device_id, content_type)
    date_list_dict = redis_client2.hgetall(key)
    read_list_v2 = []
    today_read = []
    if date_list_dict:
        before_5_days_date = get_before_5_days_date()
        today_read = json.loads(date_list_dict.get(before_5_days_date[0].encode(), "[]"))
        #删除5天以外的已读记录
        for day in date_list_dict:
            day_decode = day.decode()
            if day_decode in before_5_days_date:
                read_list_v2.extend(json.loads(date_list_dict[day]))
            else:
                redis_client2.hdel(key, day)
    return read_list_v2, today_read


def user_portrait_tag3_get_candidate_dict(device_id, content_type, latest=False):
    key = _user_portrait_tag3_get_candidate_key(device_id, content_type, latest)
    res = redis_client4.get(key)
    if res:
        return json.loads(res)
    return {}


def user_portrait_tag3_get_candidate_unread_list(device_id, content_type, size=500):
    """
    device_id:
    content_type: diary
    return: []
    """
    queue = []
    read_list, _ = get_user_portrait_tag3_read_v2(device_id, content_type)
    diary_dict = user_portrait_tag3_get_candidate_dict(device_id, "diary")
    if diary_dict:
        # lol = remove_read_with_size(diary_dict.values(), "diary", read_list, size)
        lol = diary_dict.values()
        queue = merge_lists(*lol)
        get_n_unread_data_from_ids(queue, size, read_list)
    return queue


def user_portrait_tag3_write_ctcvr_data(device_id, content_type, data):
    """
    device_id:
    content_type: diary
    data: [15420031, 15531030, 16049931, 15335637, 16443431]
    return:
    """
    if data:
        key = _user_portrait_tag3_get_ctcvr_candidate_key(device_id, content_type)
        redis_client4.set(key, json.dumps(data))
        redis_client4.expire(key, 60 * 60 * 24 * 30)
