import pandas as pd


def common_elements(lst1, lst2):
    return [element for element in lst1 if element in lst2]


def nth_element(lst, n):
    if n >= len(lst):
        return ""
    return lst[n]


def create_boundaries(df, column):
    start = df[column].min()
    end = df[column].max()
    diff = end - start
    lst = [start, int(diff * 0.35), int(diff * 0.7), end]
    return pd.Series(lst).drop_duplicates().to_list()


def create_vocabulary_list(df, column):
    return list(df[column].unique())
