import timeit

import tensorflow as tf

from .fe.tractate_fe import device_tractate_fe
from .model import _bytes_feature, _float_feature, _int64_feature

_int_columns = [
    "active_type",
    "active_days",
    "card_id",
    "is_pure_author",
    "is_have_reply",
    "is_have_pure_reply",
    "content_level",
    "reply_num",
    "reply_pure_num",
    "one_reply_user_num",
    "three_reply_user_num",
    "seven_reply_user_num",
    "fifteen_reply_user_num",
    "thirty_reply_user_num",
    "sixty_reply_user_num",
    "ninety_reply_user_num",
    "history_reply_user_num",
    "one_reply_num",
    "three_reply_num",
    "seven_reply_num",
    "fifteen_reply_num",
    "thirty_reply_num",
    "sixty_reply_num",
    "ninety_reply_num",
    "history_reply_num",
    "one_click_num",
    "three_click_num",
    "seven_click_num",
    "fifteen_click_num",
    "thirty_click_num",
    "sixty_click_num",
    "ninety_click_num",
    "history_click_num",
    "one_precise_exposure_num",
    "three_precise_exposure_num",
    "seven_precise_exposure_num",
    "fifteen_precise_exposure_num",
    "thirty_precise_exposure_num",
    "sixty_precise_exposure_num",
    "ninety_precise_exposure_num",
    "history_precise_exposure_num",
    "one_vote_user_num",
    "three_vote_user_num",
    "seven_vote_user_num",
    "fifteen_vote_user_num",
    "thirty_vote_user_num",
    "sixty_vote_user_num",
    "ninety_vote_user_num",
    "history_vote_user_num",
    "one_browse_user_num",
    "three_browse_user_num",
    "seven_browse_user_num",
    "fifteen_browse_user_num",
    "thirty_browse_user_num",
    "sixty_browse_user_num",
    "ninety_browse_user_num",
    "history_browse_user_num",
    "one_share_num",
    "three_share_num",
    "seven_share_num",
    "fifteen_share_num",
    "thirty_share_num",
    "sixty_share_num",
    "ninety_share_num",
    "history_share_num",
    "first_demands_num",
    "second_demands_num",
    "first_solutions_num",
    "second_solutions_num",
    "first_positions_num",
    "second_positions_num",
    "projects_num",
    "is_related_service",
    "effect_second_skip_num",
    "business_second_skip_num",
    "service_price",
    "service_sold_num",
]
_float_columns = [
    "one_ctr",
    "three_ctr",
    "seven_ctr",
    "fifteen_ctr",
    "thirty_ctr",
    "sixty_ctr",
    "ninety_ctr",
    "history_ctr",
    # "one_vote_pure_rate",
    # "three_vote_pure_rate",
    # "seven_vote_pure_rate",
    # "fifteen_vote_pure_rate",
    # "thirty_vote_pure_rate",
    # "sixty_vote_pure_rate",
    # "ninety_vote_pure_rate",
    # "history_vote_pure_rate",
    # "one_reply_pure_rate",
    # "three_reply_pure_rate",
    # "seven_reply_pure_rate",
    # "fifteen_reply_pure_rate",
    # "thirty_reply_pure_rate",
    # "sixty_reply_pure_rate",
    # "ninety_reply_pure_rate",
    # "history_reply_pure_rate",
    "one_browse_duration_avg",
    "three_browse_duration_avg",
    "seven_browse_duration_avg",
    "fifteen_browse_duration_avg",
    "thirty_browse_duration_avg",
    "sixty_browse_duration_avg",
    "ninety_browse_duration_avg",
    "history_browse_duration_avg",
    "effect_second_skip_rate",
    "business_second_skip_rate",
]
_categorical_columns = [
    "device_id",
    "past_consume_ability_history",
    "potential_consume_ability_history",
    "price_sensitive_history",
    "show_tag_id",
    "device_fd",
    "device_sd",
    "device_fs",
    "device_ss",
    "device_fp",
    "device_sp",
    "device_p",
    "content_fd",
    "content_sd",
    "content_fs",
    "content_ss",
    "content_fp",
    "content_sp",
    "content_p",
    "fd1",
    "fd2",
    "fd3",
    "sd1",
    "sd2",
    "sd3",
    "fs1",
    "fs2",
    "fs3",
    "ss1",
    "ss2",
    "ss3",
    "fp1",
    "fp2",
    "fp3",
    "sp1",
    "sp2",
    "sp3",
    "p1",
    "p2",
    "p3",
    "click_tractate_id1",
    "click_tractate_id2",
    "click_tractate_id3",
    "click_tractate_id4",
    "click_tractate_id5",
    "service_id",
    "service_city",
    "recommend_service_id",
    "recommend_service_city",
    "recommend_service_price",
    # "device_fd2",
    # "device_sd2",
    # "device_fs2",
    # "device_ss2",
    # "device_fp2",
    # "device_sp2",
    # "device_p2",
    # "device_fd3",
    # "device_sd3",
    # "device_fs3",
    # "device_ss3",
    # "device_fp3",
    # "device_sp3",
    # "device_p3",
]

PREDICTION_ALL_COLUMNS = _int_columns + _float_columns + _categorical_columns


def model_predict_tractate(device_id, tractate_ids, device_dict, tractate_dict, predict_fn):
    try:
        time_1 = timeit.default_timer()
        device_info, tractate_lst, tractate_ids_res = device_tractate_fe(device_id, tractate_ids, device_dict, tractate_dict)
        print("predict check: " + str(len(tractate_lst)) + " " + str(len(tractate_ids_res)))
        examples = []
        for tractate_info in tractate_lst:
            tmp = {}
            tmp.update(device_info)
            tmp.update(tractate_info)
            features = {}
            for col in _int_columns:
                features[col] = _int64_feature(int(tmp[col]))
            for col in _float_columns:
                features[col] = _float_feature(float(tmp[col]))
            for col in _categorical_columns:
                features[col] = _bytes_feature(str(tmp[col]).encode(encoding="utf-8"))
            example = tf.train.Example(features=tf.train.Features(feature=features))
            examples.append(example.SerializeToString())

        total_1 = (timeit.default_timer() - time_1)
        print("make example cost {:.5f}s".format(total_1))

        time_1 = timeit.default_timer()
        predictions = predict_fn({"examples": examples})
        res_tuple = sorted(zip(tractate_ids_res, predictions["output"].tolist()), key=lambda x: x[1], reverse=True)
        res = []
        for (id, _) in res_tuple:
            res.append(int(id))
        # print(res)
        total_1 = (timeit.default_timer() - time_1)
        print("prediction cost {:.5f}s".format(total_1))
        return res
    except Exception as e:
        print(e)
        # device_info, _, _ = device_tractate_fe(device_id, tractate_ids, device_dict, tractate_dict)
        # print(device_info)
        return []
