import pandas as pd

TRACTATE_COLUMNS = [
    "card_id", "is_pure_author", "is_have_pure_reply", "is_have_reply", "content_level", "show_tag_id", "reply_num",
    "reply_pure_num", "one_ctr", "three_ctr", "seven_ctr", "fifteen_ctr", "thirty_ctr", "sixty_ctr", "ninety_ctr", "history_ctr",
    "first_demands", "second_demands", "first_solutions", "second_solutions", "first_positions", "second_positions", "projects"
]


def read_csv_data(dataset_path):
    tractate_df = pd.read_csv(dataset_path.joinpath("tractate.csv"), sep="|")
    click_df = pd.read_csv(dataset_path.joinpath("tractate_click.csv"), sep="|")
    conversion_df = pd.read_csv(dataset_path.joinpath("tractate_click_cvr.csv"), sep="|")
    return tractate_df, click_df, conversion_df


def get_tractate_from_redis():
    """
    return: {diary_id: {first_demands: [], is_pure_author: 1}}
    """
    pass


def tractate_feature_engineering(tractate_df):
    df = tractate_df.copy()

    df["first_demands"] = df["first_demands"].str.split(",")
    df["second_demands"] = df["second_demands"].str.split(",")
    df["first_solutions"] = df["first_solutions"].str.split(",")
    df["second_solutions"] = df["second_solutions"].str.split(",")
    df["first_positions"] = df["first_positions"].str.split(",")
    df["second_positions"] = df["second_positions"].str.split(",")
    df["projects"] = df["projects"].str.split(",")

    df["first_demands"] = df["first_demands"].apply(lambda d: d if isinstance(d, list) else [])
    df["second_demands"] = df["second_demands"].apply(lambda d: d if isinstance(d, list) else [])
    df["first_solutions"] = df["first_solutions"].apply(lambda d: d if isinstance(d, list) else [])
    df["second_solutions"] = df["second_solutions"].apply(lambda d: d if isinstance(d, list) else [])
    df["first_positions"] = df["first_positions"].apply(lambda d: d if isinstance(d, list) else [])
    df["second_positions"] = df["second_positions"].apply(lambda d: d if isinstance(d, list) else [])
    df["projects"] = df["projects"].apply(lambda d: d if isinstance(d, list) else [])

    df["is_pure_author"] = df["is_pure_author"].astype(int)
    df["is_have_pure_reply"] = df["is_have_pure_reply"].astype(int)
    df["is_have_reply"] = df["is_have_reply"].astype(int)

    print("tractate:")
    nullseries = df.isnull().sum()
    print(nullseries[nullseries > 0])
    print(df.shape)
    return df[TRACTATE_COLUMNS]


def join_features(device_df, tractate_df, cc_df):
    pass


def device_tractate_fe(device_id, tractate_ids, device_dict, tractate_dict):
    pass
