import datetime
import json
import random

from .cache import redis_client2, redis_client4


def get_n_unread_data_from_ids(data, size, read_lst):
    """
    data: ['852170', '864084', '231589']
    """
    res = []
    for id_str in data:
        id = int(id_str)
        if len(res) >= size:
            break
        elif (id not in set(read_lst)) and (id not in res):
            res.append(id)
    return res


# 获取前1天或N天的日期，beforeOfDay=1：前1天；beforeOfDay=N：前N天
def getdate(beforeOfDay):
    today = datetime.datetime.now()
    # 计算偏移量
    offset = datetime.timedelta(days=-beforeOfDay)
    # 获取想要的日期的时间
    re_date = (today + offset).strftime("%Y-%m-%d")
    return re_date


def get_before_5_days_date():
    return [getdate(i) for i in range(5)]


def user_portrait_tag3_get_candidate_key(device_id, content_type, latest=False):
    """
    content_type: diary, tractate, answer
    """
    key = "doris:user_portrait:tag3:candidate:{}:device_id:".format(content_type) + str(device_id)
    if latest:
        key = "doris:user_portrait:tag3:candidate_latest:{}:device_id:".format(content_type) + str(device_id)
    return key


def get_user_portrait_tag3_read_key_v2(device_id, content_type):
    return "doris:user_portrait:tag3:read_v2:device_id:{}:content_type:{}".format(device_id, content_type)


def get_user_portrait_tag3_read_v2(device_id, content_type):
    key = get_user_portrait_tag3_read_key_v2(device_id, content_type)
    date_list_dict = redis_client2.hgetall(key)
    read_list_v2 = []
    today_read = []
    if date_list_dict:
        before_5_days_date = get_before_5_days_date()
        today_read = json.loads(date_list_dict.get(before_5_days_date[0].encode(), "[]"))
        #删除5天以外的已读记录
        for day in date_list_dict:
            day_decode = day.decode()
            if day_decode in before_5_days_date:
                read_list_v2.extend(json.loads(date_list_dict[day]))
            else:
                redis_client2.hdel(key, day)
    return read_list_v2, today_read


def user_portrait_tag3_get_candidate_dict(device_id, content_type, latest=False):
    key = user_portrait_tag3_get_candidate_key(device_id, content_type, latest)
    res = redis_client4.get(key)
    if res:
        return json.loads(res)
    return {}


def user_portrait_tag3_get_unread_list(device_id, content_type):
    """
    device_id:
    content_type: diary
    return: []
    """
    read_list, _ = get_user_portrait_tag3_read_key_v2(device_id, content_type)
    candidate_list = list(user_portrait_tag3_get_candidate_key(device_id, content_type).values())
    return get_n_unread_data_from_ids(candidate_list, 500, read_list)
