import tensorflow as tf


def esmm_input_fn(dataframe, shuffle=False, batch_size=256):
    df = dataframe.copy()
    target = df[["click_label", "conversion_label"]]
    ds = tf.data.Dataset.from_tensor_slices((dict(df), dict(target)))
    if shuffle:
        ds = ds.shuffle(1000).repeat()
    return ds.batch(batch_size).make_one_shot_iterator().get_next()
