# coding=utf-8
import json

import tablib
import requests
from django.core.management import BaseCommand
from hera.utils import get_mail_instance, attach_title
from rpc.tool.log_tool import log_audit_hera
from themis.models import Team
from api.models import Service


def send_export_mail(subject, body, to_list, dt, send=True):
    if not isinstance(to_list, (list, tuple)):
        to_list = [to_list]
    mail = get_mail_instance(subject, body, to_list)
    mail.attach(attach_title(u'{}.xlsx'.format(subject)), dt.xlsx)
    if send:
        mail.send()

    # audit log
    audit_data = {
        'audit_type': 'export_excel',
        'email_title': subject,
        'email_to': to_list,
        # 'excel_data': dt.xlsx,
        # 'excel_name': u'{}.xlsx'.format(subject),
    }
    log_audit_hera(audit_data)
    return mail


class Command(BaseCommand):

    def handle(self, *args, **options):
        services = Service.objects.filter(is_online=True)
        dt_service = tablib.Dataset()
        dt_service.headers = (u'美购ID', u'图片是否达标', u'医生名', u'机构名', u'医生ID', u'商务名称', u'所属大区')
        for service in services:
            try:
                if service.image_header:
                    if service.doctor:
                        doc_name = service.doctor.name
                        doc_id = service.doctor.id
                        bus_name = service.doctor.business_partener.username
                        if service.doctor.hospital:
                            hos_name = service.doctor.hospital.name
                        else:
                            hos_name = ''
                        if service.doctor.business_group:
                            area = Team.objects.get(id=service.doctor.business_group).name
                        else:
                            area = ''
                    else:
                        doc_name = ''
                        doc_id = ''
                        hos_name = ''
                        bus_name = ''
                        area = ''
                    url = service.image_header + '?imageInfo'
                    print url
                    result = json.loads(requests.get(url).text)
                    print result
                    error = result.get('error', None)
                    if error:
                        continue
                    elif result['width'] >= 400 and result['height'] >= 400:
                        dt_service.append((service.id, u'是', doc_name, hos_name, doc_id, bus_name, area))
                        print service.id
                    else:
                        dt_service.append((service.id, u'否', doc_name, hos_name, doc_id, bus_name, area))
                        print 'not-{}'.format(service.id)
            except:
                continue

        dt_service.title = u'美购头图大小信息'

        to_list = ['zhouyang@igengmei.com', 'lichunqi@igengmei.com',
                   'lihaonan@igengmei.com', 'chenxiangyu@igengmei.com']
        send_export_mail(u'美购头图大小信息', u'美购头图大小信息', to_list, dt_service)

        print 'DONE'

