#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   17/07/18 14:38:30
#   Desc    :   设置医院相关属性
#

from collections import namedtuple

import xlrd

from django.core.management import BaseCommand

from hippo.models import Hospital


location = '/tmp/商家分级表.xlsx'


Hdict = namedtuple(
    'Hdict', 'id name chief_ph_count associate_chief_ph_count \
    ph_in_charge_count resident_ph_count ph_count area_count city_count \
    chain_count is_high_quality level operation_room_count injection_room_count \
    aser_room_count')


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        data = xlrd.open_workbook(location)
        table = data.sheets()[0]
        rows = {x[0].value: x for x in list(table.get_rows())[1:]}
        hospitals = Hospital.objects.filter(id__in=rows.keys())
        fail_id = set(rows.keys()) - {x.id for x in hospitals}
        print('未找到医院id: {}'.format(' '.join(fail_id) if fail_id else '无'))

        for hospital in hospitals:
            hdict = Hdict(*rows[hospital.id])
            for key in hdict._fields[2:]:
                value = str(getattr(hdict, key).value).strip() or 0
                setattr(hospital, key, int(float(value)))
            hospital.save()
