#!/usr/bin/env python
# coding=utf-8
from django.db import models

class UserList(models.Model):
    """
    订单相关以及私信、浏览等id皆为最新记录
    """
    class Meta:
        verbose_name = u'用户列表'
        verbose_name_plural = u'用户列表'
        db_table = 'hippo_userlist'
        app_label = 'hippo'
        unique_together = [
            ('user_id', 'merchant_id')
        ]

    """
    user_id：用户表主键id
    doctor_user_id：用户表主键id
    merchant_id：Merchant商户表主键id
    amount：Order表订单金额汇总
    browse_id：MerchantPvStat表主键id
    conversation_id：Conversation表的主键id
    order_pay_id:Order支付订单订单号
    order_validated_id:Order表验证订单订单号
    """
    user_id=models.IntegerField(verbose_name='用户id')
    doctor_user_id = models.IntegerField(verbose_name='私信医生的用户id',blank=True, null=True)
    merchant_id=models.BigIntegerField(verbose_name='用户所属商户id')
    amount = models.FloatField(verbose_name='消费金额',default=0)
    browse_id = models.IntegerField(verbose_name='浏览记录id', blank=True, null=True, db_index=True)
    conversation_id = models.IntegerField(verbose_name='私信id', blank=True, null=True, db_index=True)
    order_pay_id = models.CharField(max_length=64, verbose_name=u'支付订单号', null=True, blank=True, db_index=True)
    order_validated_id = models.CharField(max_length=64, verbose_name=u'验证订单号', null=True, blank=True, db_index=True)
    user_remarks = models.CharField(max_length=256, verbose_name='医生给用户的私信备注', null=True, blank=True)
    browse_time = models.DateTimeField(verbose_name=u'浏览时间', blank=True, null=True)
    order_pay_time = models.DateTimeField(verbose_name=u'订单支付时间', blank=True, null=True)
    order_validated_time = models.DateTimeField(verbose_name=u'订单验证时间', blank=True, null=True)
    conversation_created_time = models.DateTimeField(verbose_name=u'私信时间', blank=True, null=True)
    modify_time = models.DateTimeField(verbose_name=u'记录修改时间', auto_now=True)

