-- Deploy gaia:2017_12_15_create_api_homepageoperate to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_homepageoperate_regions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `homepageoperate_id` integer NOT NULL,
    `region_id` integer NOT NULL,
    UNIQUE (`homepageoperate_id`, `region_id`)
)
;
ALTER TABLE `api_homepageoperate_regions` ADD CONSTRAINT `region_id_refs_id_fb3149db` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);
CREATE TABLE `api_homepageoperate_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `homepageoperate_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    UNIQUE (`homepageoperate_id`, `city_id`)
)
;
ALTER TABLE `api_homepageoperate_cities` ADD CONSTRAINT `city_id_refs_id_206cde7d` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `api_homepageoperate` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `service_type` varchar(2) NOT NULL,
    `jump_type` varchar(2) NOT NULL,
    `location` varchar(2) NOT NULL,
    `title` varchar(128) NOT NULL,
    `image` varchar(1024),
    `rank` integer NOT NULL DEFAULT 999999,
    `user_type` varchar(2) NOT NULL,
    `payment_type` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `jump` varchar(1024),
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `last_time` datetime(6),
    `last_operator_id` integer NOT NULL
)
;
ALTER TABLE `api_homepageoperate` ADD CONSTRAINT `last_operator_id_refs_id_a1745947` FOREIGN KEY (`last_operator_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_homepageoperate_regions` ADD CONSTRAINT `homepageoperate_id_refs_id_8e76f666` FOREIGN KEY (`homepageoperate_id`) REFERENCES `api_homepageoperate` (`id`);
ALTER TABLE `api_homepageoperate_cities` ADD CONSTRAINT `homepageoperate_id_refs_id_72b5791e` FOREIGN KEY (`homepageoperate_id`) REFERENCES `api_homepageoperate` (`id`);

COMMIT;
