-- Deploy gaia:hippo_2018_05_31_merchant_info to mysql

BEGIN;

CREATE TABLE `hippo_merchantaccount` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `merchant_id` bigint NOT NULL UNIQUE,
    `country_id` varchar(40),
    `province_id` varchar(40),
    `city_id` varchar(40),
    `bank` varchar(30) NOT NULL,
    `subbranch` varchar(100),
    `account_name` varchar(100) NOT NULL,
    `account_number` varchar(50) NOT NULL,
    `account_type` integer NOT NULL,
    `status` integer NOT NULL,
    `city_finance_id` integer
);
ALTER TABLE `hippo_merchantaccount` ADD CONSTRAINT `city_finance_id_refs_id_f9f06d96` FOREIGN KEY (`city_finance_id`) REFERENCES `api_finance_city` (`id`);
ALTER TABLE `hippo_merchantaccount` ADD CONSTRAINT `merchant_id_refs_id_7d2e5c03` FOREIGN KEY (`merchant_id`) REFERENCES `hippo_merchant` (`id`);
ALTER TABLE `hippo_merchantaccount` ADD CONSTRAINT `country_id_refs_id_170b8d2d` FOREIGN KEY (`country_id`) REFERENCES `api_country` (`id`);
ALTER TABLE `hippo_merchantaccount` ADD CONSTRAINT `province_id_refs_id_544e6f61` FOREIGN KEY (`province_id`) REFERENCES `api_province` (`id`);
ALTER TABLE `hippo_merchantaccount` ADD CONSTRAINT `city_id_refs_id_8064540e` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);

CREATE TABLE `hippo_merchantaccountrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `account_id` integer NOT NULL,
    `status` integer NOT NULL,
    `reject_reason` varchar(100),
    `handler_id` char(32),
    `created_at` datetime(6) NOT NULL,
    `content` longtext NOT NULL
);
ALTER TABLE `hippo_merchantaccountrecord` ADD CONSTRAINT `account_id_refs_id_34e5c8ef` FOREIGN KEY (`account_id`) REFERENCES `hippo_merchantaccount` (`id`);
ALTER TABLE `hippo_merchantaccountrecord` ADD CONSTRAINT `handler_id_refs_id_bc6310e8` FOREIGN KEY (`handler_id`) REFERENCES `api_person` (`id`);

CREATE TABLE `hippo_merchantlicense` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `merchant_id` bigint NOT NULL UNIQUE,
    `lincense_img` varchar(256) NOT NULL,
    `lincense_name` varchar(100) NOT NULL,
    `lincense_number` varchar(100) NOT NULL,
    `lincense_start_time` datetime(6) NOT NULL,
    `lincense_end_time` datetime(6)
);
ALTER TABLE `hippo_merchantlicense` ADD CONSTRAINT `merchant_id_refs_id_8c959363` FOREIGN KEY (`merchant_id`) REFERENCES `hippo_merchant` (`id`);

CREATE TABLE `hippo_merchantbillinfo` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `info_type` integer NOT NULL,
    `register_address` varchar(50) NOT NULL,
    `register_phone` varchar(50) NOT NULL,
    `account_name` varchar(50) NOT NULL,
    `bank_account` varchar(50) NOT NULL,
    `receiver_name` varchar(40) NOT NULL,
    `receiver_phone` varchar(40) NOT NULL,
    `receiver_address` varchar(100) NOT NULL,
    `email` varchar(200) NOT NULL,
    `merchant_id` bigint NOT NULL UNIQUE
);
ALTER TABLE `hippo_merchantbillinfo` ADD CONSTRAINT `merchant_id_refs_id_cef9b30c` FOREIGN KEY (`merchant_id`) REFERENCES `hippo_merchant` (`id`);

CREATE TABLE `hippo_merchantagreement` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `merchant_id` bigint NOT NULL UNIQUE,
    `first_company_name` varchar(100) NOT NULL,
    `first_company_number` varchar(100) NOT NULL,
    `hosting_type` integer NOT NULL,
    `first_hosting_company_name` varchar(100),
    `first_hosting_company_number` varchar(100),
    `first_hosting_single_name` varchar(100),
    `first_hosting_single_type` integer NOT NULL,
    `first_hosting_single_number` varchar(100) NOT NULL,
    `second_company_name` varchar(100) NOT NULL,
    `agreement_start_time` datetime(6) NOT NULL,
    `agreement_end_time` datetime(6),
    `enter_amount` integer NOT NULL,
    `cash_deposit` integer NOT NULL,
    `agreement_type` integer NOT NULL,
    `business_type` integer NOT NULL
);
ALTER TABLE `hippo_merchantagreement` ADD CONSTRAINT `merchant_id_refs_id_f0e675fd` FOREIGN KEY (`merchant_id`) REFERENCES `hippo_merchant` (`id`);

CREATE TABLE `hippo_merchantagreementimg` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `merchantagreement_id` integer NOT NULL,
    `img_url` varchar(256) NOT NULL,
    `img_type` integer NOT NULL
);
ALTER TABLE `hippo_merchantagreementimg` ADD CONSTRAINT `merchantagreement_id_refs_id_69a2231c` FOREIGN KEY (`merchantagreement_id`) REFERENCES `hippo_merchantagreement` (`id`);

CREATE TABLE `hippo_merchantagreementrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `merchant_id` bigint NOT NULL,
    `status` integer NOT NULL,
    `reject_reason` varchar(100),
    `proposer_id` integer NOT NULL,
    `handler_id` integer,
    `created_at` datetime(6) NOT NULL,
    `handle_at` datetime(6) NULL,
    `first_company_name` varchar(100) NOT NULL,
    `first_company_number` varchar(100) NOT NULL,
    `hosting_type` integer NOT NULL,
    `first_hosting_company_name` varchar(100) NOT NULL,
    `first_hosting_company_number` varchar(100) NOT NULL,
    `first_hosting_single_name` varchar(100) NOT NULL,
    `first_hosting_single_type` integer NOT NULL,
    `first_hosting_single_number` varchar(100) NOT NULL,
    `second_company_name` varchar(100) NOT NULL,
    `agreement_start_time` datetime(6) NOT NULL,
    `agreement_end_time` datetime(6),
    `enter_amount` integer NOT NULL,
    `cash_deposit` integer NOT NULL,
    `agreement_type` integer NOT NULL,
    `business_type` integer NOT NULL
);
ALTER TABLE `hippo_merchantagreementrecord` ADD CONSTRAINT `merchant_id_refs_id_63c2cee7` FOREIGN KEY (`merchant_id`) REFERENCES `hippo_merchant` (`id`);
ALTER TABLE `hippo_merchantagreementrecord` ADD CONSTRAINT `proposer_id_refs_id_eab5442d` FOREIGN KEY (`proposer_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `hippo_merchantagreementrecord` ADD CONSTRAINT `handler_id_refs_id_eab5442d` FOREIGN KEY (`handler_id`) REFERENCES `auth_user` (`id`);

CREATE TABLE `hippo_merchantagreementrecordimg` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `record_id` integer NOT NULL,
    `img_url` varchar(256) NOT NULL,
    `img_type` integer NOT NULL
);
ALTER TABLE `hippo_merchantagreementrecordimg` ADD CONSTRAINT `merchantagreement_id_refs_id_69a2231d` FOREIGN KEY (`record_id`) REFERENCES `hippo_merchantagreementrecord` (`id`);

ALTER TABLE `hippo_hospital_extra` ADD COLUMN `ad_check_img` varchar(256);
ALTER TABLE `hippo_hospital_extra` ADD COLUMN `practice_start_time` datetime(6);
ALTER TABLE `hippo_hospital_extra` ADD COLUMN `practice_end_time` datetime(6);

COMMIT;
