# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from .basic import DocumentLoader
from ..configurations.alpha import Alpha

import unittest


docstring = """

同志们好！

{-# Straight Configuration Alpha Typedef #-}

{- 输入参数 -}
data Params = {
    id: Int -- 帖子ID
}

{- 返回值 -}
data Result = {
    id: Int
    x: Real
    y: Real
}

{-# Straight End #-}

同志们辛苦了！

"""


class TestBasicAlpha(unittest.TestCase):

    def create_loader(self):
        return DocumentLoader(
            configuration_map={
                'Alpha': Alpha,
            }
        )

    def test_create(self):
        self.create_loader()

    def test_1(self):
        loader = self.create_loader()

        fd = loader.parse_docstring(docstring)
        assert {'id': 0} in fd.params.typing
        assert {'id': 0.0} not in fd.params.typing

        assert {'id': 0, 'x': 1.2, 'y': 3.4} in fd.result.typing

        assert fd.params.description.strip() == '{- 输入参数 -}'

        assert fd.description.strip().startswith('同志们好')
        assert fd.description.strip().endswith('同志们辛苦了！')

