# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, print_function
import datetime
from django.db import models
from django.utils import timezone
from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.mimas.qa import VIDEO_SOURCE_TYPE


class Tractate(models.Model):
    """
    短文（新帖子）
    """

    class Meta:
        verbose_name = u'新帖子'
        db_table = 'api_tractate'
        app_label = 'talos'

    user_id = models.IntegerField(verbose_name="用户id", db_index=True)
    create_time = models.DateTimeField(verbose_name="创建时间", default=timezone.now)
    is_online = models.BooleanField(verbose_name=u'是否上线', default=True, db_index=True)



class TractateVideo(models.Model):
    """
    新帖子 视频相关
    """

    class Meta:
        verbose_name = u'新帖子视频相关'
        db_table = 'api_tractate_video'
        app_label = 'talos'

    tractate_id = models.IntegerField(verbose_name="新帖子id", db_index=True)
    video_cover_url = models.CharField(max_length=300, verbose_name="视频封面图地址", default="")
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class TractateImages(models.Model):
    """
    新帖子 图片相关
    默认第一张图片为封面图，故未设置 is_cover 字段
    """

    class Meta:
        verbose_name = u'新帖子图片相关'
        db_table = 'api_tractate_images'
        app_label = 'talos'

    tractate_id = models.IntegerField(verbose_name="新帖子id", db_index=True)
    image_url = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'图片地址')


class VideoCover(models.Model):
    class Meta:
        db_table = 'api_video_cover'
        app_label = 'talos'
        index_together = [
            ['video_url'],
        ]

    source_id = models.IntegerField(verbose_name=u'视频来源ID', null=False)
    source_type = models.SmallIntegerField(verbose_name=u'视频来源类型', choices=VIDEO_SOURCE_TYPE)
    video_url = models.CharField(max_length=128, verbose_name=u'视屏地址')


class SoftArticle(models.Model):

    class Meta:
        verbose_name=u'软文章'
        db_table='api_doctor_softarticle'
        app_label='talos'

    doctor_id=models.CharField(verbose_name="医生id", db_index=True, max_length=64)
    merchant_id=models.CharField(verbose_name="商户id", db_index=True, max_length=64)
    is_online=models.BooleanField(verbose_name=u"是否在线", default=True)
    hera_is_online=models.BooleanField(verbose_name=u"最终是否上下线", default=False)
    last_modified=models.DateTimeField(verbose_name=u'最后修改时间', auto_now=True)
