# coding=utf-8
from celery import shared_task
from rpc.context import get_rpc_remote_invoker
from gm_types.antispam import DocType
rpc_invoker = get_rpc_remote_invoker()

@shared_task
def antispam_feedback(doc_id, doc_type):
    """
    问答垃圾反馈
    :param doc_id: ids
    :param doc_type: gm_types.antispam.Doctype
    :return:
    """
    doc = None
    if doc_type == DocType.ANSWER:
        doc = rpc_invoker['qa/answer/lst_for_task'](type_q='answer',ids=[doc_id]).unwrap()
    elif doc_type == DocType.QUESTION:
        doc = rpc_invoker['qa/answer/lst_for_task'](type_q='question', ids=[doc_id]).unwrap()
    elif doc_type == DocType.COMMENT:
        doc = rpc_invoker['qa/answer/lst_for_task'](type_q='answerreply', ids=[doc_id]).unwrap()
    if doc:
        rpc_invoker['antispam/feedback'](
            doc_id=doc[0].get('id'),
            doc_type=doc_type,
            content=doc[0].get('content'),
            spam=doc[0].get('is_spam')
        ).unwrap()


@shared_task
def antispam_feedback_batch(doc_ids, doc_type):
    docs = None
    if doc_type == DocType.ANSWER:
        docs = rpc_invoker['qa/answer/lst_for_task'](type_q='answer', ids=doc_ids).unwrap()
    elif doc_type == DocType.QUESTION:
        docs = rpc_invoker['qa/answer/lst_for_task'](type_q='question', ids=doc_ids).unwrap()
    elif doc_type == DocType.COMMENT:
        docs = rpc_invoker['qa/answer/lst_for_task'](type_q='answerreply', ids=doc_ids).unwrap()
    if docs:
        rpc_invoker['antispam/feedback/batch'](
            docs=[{
                      'doc_id': doc.get('id'),
                      'doc_type': doc_type,
                      'spam': doc.get('is_spam'),
                      'content': doc.get('content'),
                  } for doc in docs]).unwrap()
