# -*- coding: UTF-8 -*-
from django.conf import settings
from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from gm_types.gaia import DIARY_CONTENT_LEVEL, USER_CLASSIFY

from statistic.models import ClassifyUser
from talos.models.diary import DiaryCheck
from . import TalosDataSQLQuery


class DiarycheckDB(DataBuilder):
    def getval_content(self, obj):
        return DIARY_CONTENT_LEVEL.getDesc(obj.content_level)

    def getval_send_message(self, obj):
        return obj.title + obj.send_message

    def getval_check_time(self, obj):
        return str(obj.check_time).split('.')[0]


@DB
class DiarycheckDQ(TalosDataSQLQuery):
    model = DiaryCheck
    data_model = DiarycheckDB

    def filter_is_real_case(self, srch_key, srch_val, regex=False):
        user_ids = ClassifyUser.objects.using(settings.SLAVE_DB_NAME).filter(
            classify=USER_CLASSIFY.MODEL).values_list('user_id', flat=True)
        q = Q(user_id__in=list(user_ids))
        if srch_val == USER_CLASSIFY.NORMAL:
            return ~q
        elif srch_val == USER_CLASSIFY.MODEL:
            return q
        else:
            return Q()
