# coding=utf-8
# create by oldman at 2017/10/11
from django.db import models


class FinanceProvince(models.Model):
    class Meta:
        verbose_name = u'医生打款的省份'
        db_table = 'api_finance_province'
        app_label = 'api'

    name = models.CharField(verbose_name=u'省份', max_length=50, null=False)

    @property
    def cities(self):
        """
        返回省份下面的全部城市
        :return:
        """
        cities = FinanceCity.objects.filter(province_id=self.id)
        return [
            {
                'province_id': self.id,
                'province_name': self.name,
                'city_id': item.id,
                'city_name': item.name,
            } for item in cities]


class FinanceCity(models.Model):
    class Meta:
        verbose_name = u'医生打款的城市'
        db_table = 'api_finance_city'
        app_label = 'api'

    name = models.CharField(verbose_name=u'城市', max_length=50, null=False)
    province = models.ForeignKey(FinanceProvince, verbose_name=u'省份', related_name='province')
