# coding=utf-8
from django.conf import settings
from gm_dbmw_api.descriptor import source, relation
from gm_types.mq.dbmw import DBMWEndPoints

pk_data_source = source.GroupedSource.of(
    source.MySQLTableSource(
        logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
        table_name="api_service",
        key_columns=['id'],
        value_columns_excluded=[],
        value_columns_all=True,
    ),
    source.RelatedSource(
        source=source.GroupedSource.of(
            source.MySQLTableSource(
                logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                table_name="api_serviceitem",
                key_columns=['id'],
                value_columns_excluded=[],
                value_columns_all=True,
            ),
            source.RelatedSource(
                source=source.GroupedSource.of(
                    source.MySQLTableSource(
                        logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                        table_name="api_serviceitemprice",
                        key_columns=['id'],
                        value_columns_excluded=[],
                        value_columns_all=True,
                    ),
                    source.RelatedSource(
                        source=source.MySQLTableSource(
                            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                            table_name="api_skupricerule",
                            key_columns=['id'],
                            value_columns_excluded=[],
                            value_columns_all=True,
                        ),
                        relation=relation.MySQLTableRelation(
                            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                            table_name="api_serviceitemprice",
                            from_columns=["selling_rule_id"],
                            to_columns=["id"],
                        )
                    )
                ),
                relation=relation.MySQLTableRelation(
                    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                    table_name="api_serviceitemprice",
                    from_columns=["id"],
                    to_columns=["service_item_id"],
                )
            )
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_serviceitem",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_servicetag",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_servicetag",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_diary",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_diary",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_specialitem",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_specialitem",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.GroupedSource.of(
            source.MySQLTableSource(
                logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                table_name="api_doctor",
                key_columns=['id'],
                value_columns_excluded=['view_num', 'reply_num', 'new_pm_num', 'reply_pm_num', 'no_reply_pm_num',
                                        'share_topic_num', 'last_answered_time'],
                value_columns_all=True,
            ),
            source.GMMQSource(
                endpoint=DBMWEndPoints.PUNISHMENT_TRIGGER,
            ),
            source.RelatedSource(
                source=source.GroupedSource.of(
                    source.MySQLTableSource(
                        logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                        table_name="api_hospital",
                        key_columns=['id'],
                        value_columns_excluded=[],
                        value_columns_all=True,
                    ),
                    source.RelatedSource(
                        source=source.GroupedSource.of(
                            source.MySQLTableSource(
                                logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                                table_name="api_city",
                                key_columns=['id'],
                                value_columns_excluded=[],
                                value_columns_all=True,
                            ),
                            source.RelatedSource(
                                source=source.MySQLTableSource(
                                    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                                    table_name="api_province",
                                    key_columns=['id'],
                                    value_columns_excluded=[],
                                    value_columns_all=True,
                                ),
                                relation=relation.MySQLTableRelation(
                                    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                                    table_name="api_city",
                                    from_columns=["province_id"],
                                    to_columns=["id"],
                                )
                            )
                        ),
                        relation=relation.MySQLTableRelation(
                            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                            table_name="api_hospital",
                            from_columns=["city_id"],
                            to_columns=["id"],
                        )
                    ),
                    source.RelatedSource(
                        source=source.MySQLTableSource(
                            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                            table_name="api_period_hospital",
                            key_columns=['id'],
                            value_columns_excluded=[],
                            value_columns_all=True,
                        ),
                        relation=relation.MySQLTableRelation(
                            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                            table_name="api_period_hospital",
                            from_columns=["id"],
                            to_columns=["hospital_id"],
                        )
                    )
                ),
                relation=relation.MySQLTableRelation(
                    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                    table_name="api_doctor",
                    from_columns=["hospital_id"],
                    to_columns=["id"],
                )
            )
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_service",
            from_columns=["doctor_id"],
            to_columns=["id"],
        )
    ),
    source.RelatedSource(
        source=source.GroupedSource.of(
            source.MySQLTableSource(
                logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                table_name="api_hospital",
                key_columns=['id'],
                value_columns_excluded=[],
                value_columns_all=True,
            ),
            source.RelatedSource(
                source=source.GroupedSource.of(
                    source.MySQLTableSource(
                        logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                        table_name="api_city",
                        key_columns=['id'],
                        value_columns_excluded=[],
                        value_columns_all=True,
                    ),
                    source.RelatedSource(
                        source=source.MySQLTableSource(
                            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                            table_name="api_province",
                            key_columns=['id'],
                            value_columns_excluded=[],
                            value_columns_all=True,
                        ),
                        relation=relation.MySQLTableRelation(
                            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                            table_name="api_city",
                            from_columns=["province_id"],
                            to_columns=["id"],
                        )
                    )
                ),
                relation=relation.MySQLTableRelation(
                    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                    table_name="api_hospital",
                    from_columns=["city_id"],
                    to_columns=["id"],
                )
            )
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_service",
            from_columns=["hospital_id"],
            to_columns=["id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_ticketsresult",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_service",
            from_columns=["tickets_result_id"],
            to_columns=["id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_smart_rank",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_smart_rank",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_servicerecommend",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_servicerecommend",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_advertisemanagement",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_advertisemanagement",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_order",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_order",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    )
)
index_data_source = source.GroupedSource.of(
    source.MySQLTableSource(
        logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
        table_name="api_service",
        key_columns=['id'],
        value_columns_excluded=[],
        value_columns_all=True,
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_servicetag",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_servicetag",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_diary",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_diary",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_specialitem",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_specialitem",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_servicerecommend",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_servicerecommend",
            from_columns=["id"],
            to_columns=["service_id"],
        )
    )
)
