-- Deploy gaia:api_2018_08_08_add_cloumn_with_special to mysql

BEGIN;

ALTER TABLE `api_coupon` ADD COLUMN `groupbuy_avail` bool NOT NULL DEFAULT FALSE ;
ALTER TABLE `api_special` ADD COLUMN `groupbuy_id` integer UNIQUE;
CREATE TABLE `api_groupbuyspecial` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `groupbuy_type` integer DEFAULT 1,
    `nums` integer,
    `countdown` integer
)
;
ALTER TABLE `api_special` ADD CONSTRAINT `groupbuy_id_refs_id_80fec79d` FOREIGN KEY (`groupbuy_id`) REFERENCES `api_groupbuyspecial` (`id`);

ALTER TABLE `api_skupricerule`
ADD COLUMN `groupbuy_type` integer,
ADD COLUMN `groupbuy_nums` integer,
ADD COLUMN `groupbuy_countdown` integer;

ALTER TABLE `api_skupricerule` ADD UNIQUE api_skupricerule_unique_index (`activity_id`, `activity_type`);

-- ALTER TABLE `api_order`
-- ADD COLUMN `groupbuy_status` integer NOT NULL DEFAULT 0,
-- ADD COLUMN `join_groupbuy_team_id` integer;

CREATE TABLE `api_groupbuy_team` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hash_id` varchar(16) NOT NULL UNIQUE,
    `min_user_number` integer NOT NULL,
    `left_user_number` integer NOT NULL,
    `current_user_number` integer NOT NULL,
    `gb_type` integer NOT NULL,
    `status` integer NOT NULL,
    `service_item_id` integer NOT NULL,
    `price_id` integer NOT NULL,
    `creator_user_id` integer NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `success_time` datetime(6),
    `update_time` datetime(6) NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_groupbuyteam_order` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `groupbuy_team_id` integer NOT NULL,
    `order_id` varchar(12) NOT NULL,
    `paid` bool NOT NULL
)
;

ALTER TABLE `api_groupbuyteam_order` ADD CONSTRAINT `groupbuy_team_id_refs_id_e25f8f4b` FOREIGN KEY (`groupbuy_team_id`) REFERENCES `api_groupbuy_team` (`id`);
CREATE INDEX `api_groupbuy_team_4db2dfbd` ON `api_groupbuy_team` (`hash_id`);
CREATE INDEX `api_groupbuy_team_09188d5f` ON `api_groupbuy_team` (`service_item_id`, `status`);
CREATE INDEX `api_groupbuy_team_c1c4c920` ON `api_groupbuy_team` (`end_time`);
CREATE INDEX `api_groupbuyteam_order_a6177f94` ON `api_groupbuyteam_order` (`groupbuy_team_id`);
CREATE INDEX `api_groupbuyteam_order_1b89fe59` ON `api_groupbuyteam_order` (`order_id`);

COMMIT;
