# encoding=utf-8

from rpc.decorators import bind_context
from api.models import WordRel
from hera.utils import model_edit, commastr_to_list

uri_pre = 'hera/new_tag/'


@bind_context(uri_pre + 'sync')
def sync_old_tag_to_new(ctx, **kwargs):
    """
    运营标签
    同步数据 旧标签到新标签
    :param kwargs: {"category": "18", "keyword": "122ssss", "synonyms_string": "", "resembles_string": ""}
    :return:
    """
    keyword = kwargs['keyword']
    WordRel.check_constraint([keyword])
    synonym_str = kwargs.pop('synonyms_string', None)
    kwargs['synonym_list'] = None
    if synonym_str is not None:
        synonym_list = commastr_to_list(synonym_str)
        WordRel.check_constraint(synonym_list)
        synonym_list.append(keyword)
        kwargs['synonym_list'] = synonym_list

    resemble_str = kwargs.pop('resembles_string', None)
    kwargs['resemble_list'] = None
    if resemble_str is not None:
        resemble_list = commastr_to_list(resemble_str)
        kwargs['resemble_list'] = resemble_list

    synonym_list = kwargs.pop('synonym_list', None)
    resemble_list = kwargs.pop('resemble_list', None)
    obj = model_edit(WordRel, None, kwargs)
    if synonym_list is not None:
        synonym_list.append(obj.keyword)
        obj.save_synonym_words(synonym_list)
    if resemble_list is not None:
        obj.save_resemble_words(resemble_list)
    return {'id': obj.id}
