-- Deploy gaia:hippo_2017_12_11_add_doctor_hospital_extra to mysql

BEGIN;

-- XXX Add DDLs here.

CREATE TABLE `hippo_hospital_extra` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hospital_id` varchar(100) NOT NULL UNIQUE,
    `open_time` date,
    `hospital_type` integer NOT NULL,
    `hospital_level` integer NOT NULL,
    `business_area` integer NOT NULL,
    `is_same_province_chain` bool NOT NULL,
    `is_inter_province_chain` bool NOT NULL,
    `same_province_chain_hospital_id` varchar(100),
    `inter_province_chain_hospital_id` varchar(100)
)
;
ALTER TABLE `hippo_hospital_extra` ADD CONSTRAINT `hospital_id_refs_id_dddca949` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);
ALTER TABLE `hippo_hospital_extra` ADD CONSTRAINT `same_province_chain_hospital_id_refs_id_dddca949` FOREIGN KEY (`same_province_chain_hospital_id`) REFERENCES `api_hospital` (`id`);
ALTER TABLE `hippo_hospital_extra` ADD CONSTRAINT `inter_province_chain_hospital_id_refs_id_dddca949` FOREIGN KEY (`inter_province_chain_hospital_id`) REFERENCES `api_hospital` (`id`);


CREATE TABLE `hippo_doctor_extra` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL UNIQUE,
    `professional_certificate_num` varchar(100) NOT NULL,
    `professional_certificate_time` date
)
;
ALTER TABLE `hippo_doctor_extra` ADD CONSTRAINT `doctor_id_refs_id_09abf923` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `hippo_personalized_label` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(50) NOT NULL
)
;
CREATE TABLE `hippo_doctor_related_personalizedlabel` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `personalized_label_id` integer NOT NULL
)
;
ALTER TABLE `hippo_doctor_related_personalizedlabel` ADD CONSTRAINT `personalized_label_id_refs_id_980f9646` FOREIGN KEY (`personalized_label_id`) REFERENCES `hippo_personalized_label` (`id`);
ALTER TABLE `hippo_doctor_related_personalizedlabel` ADD CONSTRAINT `doctor_id_refs_id_206aba50` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `hippo_recommend_service` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `service_id` integer NOT NULL
)
;
ALTER TABLE `hippo_recommend_service` ADD CONSTRAINT `doctor_id_refs_id_5c6db9a1` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);


COMMIT;
