# -*- coding: UTF-8 -*-

from __future__ import absolute_import
from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from doctor.models import Content, HomePopup, HomeSlide, Bulletin


class ContentDB(DataBuilder):
    pass


@DB
class ContentDQ(DataSQLQuery):
        model = Content
        data_model = ContentDB

        def filter_created_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)


class PopupsDB(DataBuilder):
    pass


@DB
class PopupsDQ(DataSQLQuery):
        model = HomePopup
        data_model = PopupsDB

        def filter_begin_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)

        def filter_end_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)


class HomeSlideDB(DataBuilder):
    pass


@DB
class HomeSlideDQ(DataSQLQuery):
        model = HomeSlide
        data_model = HomeSlideDB

        def filter_begin_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)

        def filter_end_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)


class BulletinDB(DataBuilder):
    pass


@DB
class BulletinDQ(DataSQLQuery):
        model = Bulletin
        data_model = BulletinDB

        def filter_created_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)
