# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
import random
import time
import datetime

from django.db import models
from django.utils import timezone

from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import LIPSTICK_ITEM_TYPE
from api.models.user import User
from api.models import VarietyActivity, ChannelGift


class LipstickPrize(models.Model):
    class Meta:
        verbose_name = u'口红活动转盘奖品表'
        db_table = 'lipstick_prize'
        app_label = 'lipstick'

    activity = models.ForeignKey(VarietyActivity, verbose_name=u'关联口红活动', related_name='item')
    name = models.CharField(u'奖品名称', max_length=100)
    rank = models.IntegerField(u'位置', default=1)
    image = ImgUrlField(u'图片地址', img_type=IMG_TYPE.NOWATERMARK, max_length=200, default='')
    type = models.SmallIntegerField(u'奖品类型', choices=LIPSTICK_ITEM_TYPE,default=LIPSTICK_ITEM_TYPE.THANKS)
    stock = models.IntegerField(u'奖品库存', default=0)
    prob = models.IntegerField(u'概率')
    is_online = models.BooleanField(u'是否上线', default=True)
    channel_gift = models.ForeignKey(ChannelGift, verbose_name=u'渠道礼包id', null=True)
    points = models.IntegerField(u'美分', default=0)
    create_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)
    draw_count = models.IntegerField(u'领取数量', default=0)


class LipstickRecord(models.Model):
    class Meta:
        verbose_name = u'口红活动转盘获奖记录'
        db_table = 'lipstick_record'
        app_label = 'lipstick'

    item = models.ForeignKey(LipstickPrize, verbose_name=u'奖品')
    user = models.ForeignKey(User, verbose_name=u'中奖用户')
    create_time = models.DateTimeField(u'得奖时间', auto_now_add=True)
    express_info = models.TextField(u'快递信息', null=True, blank=True, default='')
    is_online = models.BooleanField(u'是否上线', default=True)


    @property
    def get_record(self):
        return {
            'name': self.item.name,
            'image': self.item.image,
            'draw_time': self.create_time.strftime('%Y-%m-%d %H:%M:%S')
        }
