# -*- coding: utf8 -*-

import datetime
from django.utils import timezone
from talos.models.topic import TopicReply


def is_reply_num_gt_limit(user):
    # 查看用户在最近一分钟内回复是否超过limit条
    limit = 3
    reply_count = TopicReply.objects.filter(user_id=user.id,
                                            reply_date__gte=timezone.now() - datetime.timedelta(minutes=1)).count()
    return reply_count >= limit
