# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function


from rpc.decorators import bind, bind_context, cache_page

from api.models import Channel


@bind("api/channels")
@bind("api/channel/list")
@cache_page(120)
def get_all_channels():
    """所有频道
    """
    result = []
    channles = Channel.objects.all().order_by('ordering')
    for channle in channles:
        result.append(channle.channel_data())
    return result
