# -*- coding: UTF-8 -*-
from django.core.management.base import BaseCommand
import json
from relation.models import UserTagRelation


class Command(BaseCommand):
    def handle(self, *args, **options):

        data = []
        user_ids = UserTagRelation.objects.values_list('user_id', flat=True).distinct()
        total = len(user_ids)
        for index, user_id in enumerate(user_ids):
            data.append({
                'user_id': user_id,
                'tags': list(UserTagRelation.objects.filter(user_id=user_id).values_list('related_tag_id', flat=True))}
            )
            print('{}/{}'.format(index, total))
        f = open('/tmp/user_tag_relation.json', 'w')
        f.write(json.dumps(data))
        f.close()
