# coding=utf-8

import datetime
import random
import time

from statistic import const_strings


def get_async_args(stat_name):
    hour = datetime.datetime.now().hour
    if stat_name == const_strings.TOPIC_VIEW:
        countdown = 10
        if 8 < hour < 23:
            repeat_time = random.randint(20, 30)
        else:
            repeat_time = random.randint(10, 15)

    elif stat_name == const_strings.TOPIC_VOTE:
        countdown = random.randint(60, 60*60)
        repeat_time = random.randint(1, 2)

    elif stat_name == const_strings.APPLY_FREE_EVENT:
        countdown = 30 * 60
        if 8 < hour < 23:
            repeat_time = random.randint(2, 4)
        else:
            repeat_time = random.randint(1, 2)

    elif stat_name == const_strings.EXCHANGE_GIFT:
        countdown = 10 * 60
        if 8 < hour < 23:
            repeat_time = random.randint(4, 6)
        else:
            repeat_time = random.randint(2, 3)

    elif stat_name == const_strings.GROUPON:
        countdown = 60 * 60
        if 8 < hour < 23:
            repeat_time = random.randint(1, 3)
        else:
            repeat_time = 1

    elif stat_name == const_strings.TOPIC_REPLY_FAKE_VOTE:
        hour = 60 * 60
        repeat_time = random.randint(2, 4)
        countdown = random.randint(hour, 2 * hour)


    else:
        repeat_time = 0
        countdown = 0

    return repeat_time, countdown

def get_countdown(repeat_times, time_range=[0, 0]):
    countdown = []
    for _ in xrange(repeat_times):
        countdown.append(random.randint(*time_range))
    return countdown


def get_async_args_v2(stat_name):
    """
    :param stat_name:
    :return: repeat: 多少人点赞, countdown: 倒计时多久开始执行, incr_range: 增加多少浏览量
    """

    incr_range = [3, 11]
    if stat_name == const_strings.TOPIC_VOTE_RULE1:
        countdown = [random.randint(30, 60)]
        incr_range = [2, 20]

    elif stat_name == const_strings.TOPIC_VOTE_RULE2:
        hour = 60 * 60
        repeat_time = random.randint(1, 4)
        countdown = get_countdown(repeat_time, (60, 2 * hour))

    elif stat_name == const_strings.TOPIC_VOTE_RULE3:
        hour = 60 * 60
        repeat_time = random.randint(1, 2)
        countdown = get_countdown(repeat_time, (22 * hour, 26 * hour))

    elif stat_name == const_strings.TOPIC_VOTE_RULE4:
        day = 60 * 60 * 24
        countdown = [get_daytime_countdown(3 * day, 5 * day)]

    elif stat_name == const_strings.TOPIC_VOTE_RULE5:
        day = 60 * 60 * 24
        countdown = [get_daytime_countdown(7 * day, 8 * day)]

    elif stat_name == const_strings.DIARY_VOTE:
        repeat_time = random.randint(1, 2)
        countdown = get_countdown(repeat_time, (60, 60 * 60))

    elif stat_name == const_strings.TOPIC_VOTE:
        repeat_time = random.randint(1, 2)
        countdown = get_countdown(repeat_time, (60, 60 * 60))

    else:
        countdown = []
        incr_range = [0, 0]

    return countdown, incr_range


def get_daytime_countdown(start, end):
    # 只返回未来日子8点到23点之间的countdown
    countdown = random.randint(start, end)
    now = time.time()
    hour = datetime.datetime.fromtimestamp(now + countdown).hour
    while not (8 <= hour <= 23):
        countdown = random.randint(start, end)
        hour = datetime.datetime.fromtimestamp(now + countdown).hour
    return countdown
