# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


from django.conf import settings


REDIS_SERVER_URL = settings.DATA_SYNC['redis_url']
REDIS_PREFIX = settings.DATA_SYNC['prefix']
ENABLE_REDIS_TABLE_EVENT_QUEUE = settings.DATA_SYNC['enqueue_table_event']

try:
    TABLE_EVENT_PROCESS_DELAY_LIST = settings.DATA_SYNC['table_event_process_delay_list']
except KeyError:
    pass

try:
    REDIS_FETCH_CHUNK_SIZE = settings.DATA_SYNC['fetch_chunk_size']
except KeyError:
    pass


REDIS_TABLE_EVENT_QUEUE_NAME = REDIS_PREFIX + ':table-event:queue'
REDIS_TABLE_EVENT_CHANNEL_NAME = REDIS_PREFIX + ':table-event:channel'
REDIS_ES_WRITE_CHANNEL_NAME = REDIS_PREFIX + ':es:write:channel'


LOGGER_NAME = 'gaia.data-sync'


ENABLE_DEBUG = False
ENABLE_ES = True

