# coding=utf-8

from django.core.management import BaseCommand

from api.models import TopicVote, DiaryVote
from api.tool.vote import VoteTool
from rpc.cache import vote_cache


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        for dv in DiaryVote.objects.all():
            u = dv.diary.user
            tool = VoteTool(vote_cache, u.id)
            tool.receive_diary_vote(dv.id)

        for tv in TopicVote.objects.all():
            u = tv.topic.user
            tool = VoteTool(vote_cache, u.id)
            tool.receive_topic_vote(tv.id)
