# -*- coding: utf-8 -*-
from django.db import models
from gm_types.gaia import (
    SKIN_CONF_ACNE_TYPE,
    SKIN_CONF_CHEEK_TYPE,
    SKIN_CONF_CHIN_TYPE,
    SKIN_CONF_COLOR_TEMP_TYPE,
    SKIN_CONF_HEITOU_TYPE,
    SKIN_CONF_MAOKONG_TYPE,
    SKIN_CONF_PIGMENTAL_TYPE,
    SKIN_CONF_SMOOTH_TYPE,
    SKIN_CONF_STRUCT_TYPE,
    SKIN_CONF_T_ZONE_TYPE,
    SKIN_CONF_VASCULAR_TYPE,
    SKIN_CONF_ACT_WRINKLE_TYPE,
    SKIN_CONF_EYE_BAG_TYPE,
)


class SkinAge(models.Model):
    class Meta:
        verbose_name = u'肤龄相关信息'
        db_table = 'api_skin_age'

    content = models.CharField(max_length=32, verbose_name="风格类型")
    max_age = models.IntegerField(verbose_name=u'上限年龄', default=0)
    min_age = models.IntegerField(verbose_name=u"下限年龄", default=0)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID", default=0)
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class SkinOil(models.Model):
    class Meta:
        verbose_name = u'皮肤油脂分类相关信息'
        db_table = 'api_skin_oil_type'

    t_zone = models.IntegerField(verbose_name="t区", choices=SKIN_CONF_T_ZONE_TYPE,
                                 default=SKIN_CONF_T_ZONE_TYPE.LEVLE_1)
    chin = models.IntegerField(verbose_name="下巴", choices=SKIN_CONF_CHIN_TYPE, default=SKIN_CONF_CHIN_TYPE.LEVLE_1)
    cheek = models.IntegerField(verbose_name="脸颊", choices=SKIN_CONF_CHEEK_TYPE, default=SKIN_CONF_CHEEK_TYPE.LEVLE_1)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class Heitou(models.Model):
    class Meta:
        verbose_name = u'黑头毛孔分类相关信息'
        db_table = 'api_heitou_type'

    heitou_level = models.IntegerField(verbose_name="黑头程度", choices=SKIN_CONF_HEITOU_TYPE,
                                       default=SKIN_CONF_HEITOU_TYPE.NONE)
    maokong_level = models.IntegerField(verbose_name="毛孔程度", choices=SKIN_CONF_MAOKONG_TYPE,
                                        default=SKIN_CONF_MAOKONG_TYPE.LIGHT)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class Acne(models.Model):
    class Meta:
        verbose_name = u'痘痘分类相关信息'
        db_table = 'api_acne_type'

    level = models.IntegerField(verbose_name="痘痘严重程度", choices=SKIN_CONF_ACNE_TYPE, default=SKIN_CONF_ACNE_TYPE.LIGHT)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class Smoothlevel(models.Model):
    class Meta:
        verbose_name = u'光滑度分类相关信息'
        db_table = 'api_smooth_level'

    level = models.IntegerField(verbose_name="光滑度", choices=SKIN_CONF_SMOOTH_TYPE,
                                default=SKIN_CONF_SMOOTH_TYPE.LEVLE_1)
    level_image = models.CharField(verbose_name=u"光滑度照片", max_length=256, default='')
    image_desc = models.CharField(verbose_name=u"照片描述", max_length=256, default='')
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class HeiYanQuan(models.Model):
    class Meta:
        verbose_name = u'黑眼圈分类相关信息'
        db_table = 'api_heiyanquan_type'

    pigmental = models.IntegerField(verbose_name="色素", choices=SKIN_CONF_PIGMENTAL_TYPE,
                                    default=SKIN_CONF_PIGMENTAL_TYPE.LEVLE_1)
    vascular = models.IntegerField(verbose_name="血管", choices=SKIN_CONF_VASCULAR_TYPE,
                                   default=SKIN_CONF_VASCULAR_TYPE.LEVLE_1)
    struct = models.IntegerField(verbose_name="结构", choices=SKIN_CONF_STRUCT_TYPE,
                                 default=SKIN_CONF_STRUCT_TYPE.LEVLE_1)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class SkinColor(models.Model):
    class Meta:
        verbose_name = u'肤色分类相关信息'
        db_table = 'api_skin_color_type'

    color_level = models.IntegerField(verbose_name="色号", null=False)
    color_image = models.CharField(verbose_name=u"色号图片", max_length=256, default='')
    color_desc = models.CharField(verbose_name=u"色号描述", max_length=256, default='')
    color_temperature = models.IntegerField(verbose_name="肤色色温", choices=SKIN_CONF_COLOR_TEMP_TYPE,
                                            default=SKIN_CONF_COLOR_TEMP_TYPE.LIGHT)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class ActWrinkle(models.Model):
    class Meta:
        verbose_name = u'法令纹'
        db_table = 'api_skin_act_wrinkle'

    state = models.IntegerField(verbose_name="状态", choices=SKIN_CONF_ACT_WRINKLE_TYPE,
                                default=SKIN_CONF_ACT_WRINKLE_TYPE.NONE)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')


class EyeBag(models.Model):
    class Meta:
        verbose_name = u'眼袋'
        db_table = 'api_skin_eye_bag'

    state = models.IntegerField(verbose_name="状态", choices=SKIN_CONF_EYE_BAG_TYPE,
                                default=SKIN_CONF_EYE_BAG_TYPE.NONE)
    analysis = models.CharField(max_length=256, verbose_name="分析文案", default='')
    polymer_id = models.IntegerField(verbose_name="聚合页ID")
    community_content = models.CharField(max_length=64, verbose_name="社区按钮文字", default='')
    service_content = models.CharField(max_length=64, verbose_name="美购按钮文字", default='')
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    seriousness = models.CharField(max_length=256, verbose_name="显著问题分析文案", default='')
