# coding=utf-8
import redis
import base64
import json
import datetime
import traceback
import logging
import hashlib
from celery import shared_task
from rpc.cache import common_cache as redis_client
from api.models.hot_wiki_keyword import Wiki_Keyword
from search.utils.es import get_es, es_index_adapt
from django.conf import settings
from api.models.estypes import Hospitals, Doctors, Areas, Countrys, Products, Projects, Brands, Items, Collect
from api.models.collect import CollectWiki
from api.models.item import NewItemWiki
from api.models.search_hot_words import ALSearchRank
from wiki.models.collect import CollectItem
from api.models.hot_tractate_keyword import Tractate_Keyword

logger = logging.getLogger('async_debug')

redis_client = None
try:
    redis_client = redis.StrictRedis.from_url(settings.DORIS_URL)
except Exception as e:
    print(e)

@shared_task
def sync_face_similar_data_to_redis():
    try:
        logging.info("get into sync_face_similar_data_to_redis")
        now = datetime.datetime.now()
        yes_time = now - datetime.timedelta(days=1)
        yes_time_str = yes_time.strftime('%Y%m%d')
        result_items = Wiki_Keyword.objects.filter(visit_time=yes_time_str).values(
            "city_id").values_list("city_id", flat=True)
        redis_key_prefix = "gaia:hot_wiki_keyword:city_id:"
        for city_id in result_items:
            redis_key = redis_key_prefix + str(city_id)
            get_result_items = Wiki_Keyword.objects.filter(visit_time=yes_time_str,
                                                           city_id=city_id,
                                                           ).order_by(
                "visit_num")
            logging.info("duan add,print get_result_items:%s" % get_result_items)

            wiki_id_list = list()
            wiki_id_visit_num = {}
            for item in get_result_items:
                if item.wiki_id not in wiki_id_visit_num.keys():
                    wiki_id_visit_num[item.wiki_id] = item.visit_num
                if item.wiki_type == 0:
                    wiki_id_list.append(item.wiki_id)
                elif item.wiki_type == 1:
                    wiki_id_list.append(10000 + item.wiki_id)
                elif item.wiki_type == 2:
                    wiki_id_list.append(20000 + item.wiki_id)
                elif item.wiki_type == 3:
                    wiki_id_list.append(30000 + item.wiki_id)

            item_list = list()
            q = {
                "_source": ["id", "name", "wikitype"],
                "query": {
                    "function_score": {
                        "query": {
                            "bool": {
                                "filter": [{
                                    "terms": {
                                        "_id": wiki_id_list
                                    }
                                },
                                    {
                                        "term": {
                                            "is_online": True
                                        }
                                    }
                                ]
                            }
                        }
                    }
                }
            }
            es = get_es()
            index = es_index_adapt(
                index_prefix=settings.ES_INDEX_PREFIX,
                doc_type='newwiki',
                rw='read'
            )
            res = es.search(
                index=index,
                doc_type='newwiki',
                timeout=settings.ES_SEARCH_TIMEOUT,
                body=q,
                from_=0,
                size=30)
            result_data = res['hits']['hits']
            logging.info("result_data:%s" % result_data)

            for item in result_data:
                wiki_id = item['_source']['id']
                wiki_name = item['_source']['name']
                wiki_type = item['_source']['wikitype']

                item_list.append(
                    {
                        "wiki_id": wiki_id,
                        "wiki_type": wiki_type,
                        "wiki_name": wiki_name,
                        "visit_num": wiki_id_visit_num[wiki_id]
                    }
                )
            item_lists = sorted(item_list, key=lambda e: e.__getitem__('visit_num'), reverse=True)
            if len(item_lists) <= 10:
                redis_client.set(redis_key, json.dumps(item_lists))
            else:
                redis_client.set(redis_key, json.dumps(item_lists[:10]))
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())


@shared_task
def es_type_data_to_redis():
    logging.info("into es ")
    try:
        QUERY_KEY = "query:{}:set"
        names = Hospitals.objects.all().values_list("name", flat=True)
        for name in names:
            query_base64 = base64.b64encode(name.encode('utf8')).decode('utf8')
            key = QUERY_KEY.format(query_base64)
            logging.info("get key:%s" % key)
            value = 'hospital'
            redis_client.sadd(key, value)
        logging.info("set redis success")

        names = Doctors.objects.all().values_list("name", flat=True)
        for name in names:
            query_base64 = base64.b64encode(name.encode('utf8')).decode('utf8')
            key = QUERY_KEY.format(query_base64)
            # logging.info("get key:%s" % key)
            value = 'doctor'
            redis_client.sadd(key, value)
        names = []
        logging.info("get into es_type_data_to_redis")
        country_names = Countrys.objects.all().values_list("name", flat=True)
        areas_names = Areas.objects.all().values_list("name", flat=True)
        names.append(country_names)
        names.append(areas_names)
        for name in names:
            if name != "china":
                logging.info("get area name:%s" % name)
                for item in name:
                    query_base64 = base64.b64encode(item.encode('utf8')).decode('utf8')
                    key = QUERY_KEY.format(query_base64)
                    logging.info("get key:%s" % key)
                    value = 'area'
                    redis_client.sadd(key, value)
        #
        pro_names = []
        proj_names = Products.objects.filter(product_type__in=[1, 2, 0])
        proje_names = Projects.objects.filter(tag_type__in=[1, 2, 3])
        item_names = Items.objects.all()
        collect_names = Collect.objects.all()
        bran_names = Brands.objects.all()
        pro_names.append(proje_names)
        pro_names.append(proj_names)
        pro_names.append(bran_names)
        pro_names.append(item_names)
        pro_names.append(collect_names)
        for name in pro_names:
            logging.info("get project name:%s" % name)
            for item in name:
                query_base64 = base64.b64encode(item.name.encode('utf8')).decode('utf8')
                key = QUERY_KEY.format(query_base64)
                value = 'project'
                redis_client.sadd(key, value)
        logging.info("set redis success")

        logging.info("get redis:%s" % redis_client)
        face_list = ['整形模拟器', '模拟器', '整容模拟器', '模拟整形', '模拟整容', '模拟',
                     '整容模拟', '整形模拟', '微整模拟器', '微整模拟', '模拟微整', '变美模拟器',
                     '整型模拟器', '模拟测试', '美容模拟器', '模拟器测试', '模拟变美', '变美模拟',
                     '美容模拟', '模拟美容', '魔镜', '更美魔镜', '变美魔镜', '测试颜值', '微整测试',
                     '整容测试', '整形测试']
        for i in face_list:
            logging.info("get list i:%s" % i)
            query_base64 = base64.b64encode(i).decode('utf8')
            key = QUERY_KEY.format(query_base64)
            logging.info("get key:%s" % key)
            value = 'face'
            redis_client.sadd(key, value)
            logging.info("set redis success")

        logging.info("get redis:%s" % redis_client)
        face_list = ['免费', '免费招募', '免费整形', '免费模特', '免费整', '招募', '模特招募', '招募模特',
                     '案例招募', '0元', '0元整形', '0元变美', '免费整形招募', '免费整招募', '免费整容',
                     '0元整容', '免费模特招募', '免费体验', '免费项目', '免费招募模特']
        for i in face_list:
            query_base64 = base64.b64encode(i).decode('utf8')
            key = QUERY_KEY.format(query_base64)
            logging.info("get key:%s" % key)
            value = 'free_face'
            redis_client.sadd(key, value)
            logging.info("set redis success")

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())


@shared_task
def sync_tractate_data_to_redis():
    try:
        logging.info("get into sync_face_similar_data_to_redis")
        now = datetime.datetime.now()
        yes_time = now - datetime.timedelta(days=1)
        yes_time_str = yes_time.strftime('%Y%m%d')
        result_items = Tractate_Keyword.objects.filter(search_time=yes_time_str).values(
            "city_id").values_list("city_id", flat=True)
        redis_key_prefix = "gaia:hot_tractate_keyword:city_id:"
        for city_id in result_items:
            redis_key = redis_key_prefix + str(city_id)
            get_result_items = Tractate_Keyword.objects.filter(search_time=yes_time_str, city_id=city_id).order_by(
                "search_num")
            logging.info("print get_result_items:%s" % get_result_items)
            item_lists = list()
            # search_num_list = dict()
            for item in get_result_items:
                item_lists.append(item.tractate_id)
                # search_num_list.append({"tractate_id": item.tractate_id, "search_num": item.search_num})
                # search_num_list[item.tractate_id] = item.search_num

            logging.info("get item_lists:%s" % item_lists)
            q = {
                "_source": ["id", "tractate_tag_name"],
                "query": {
                    "terms": {
                        "id": item_lists
                    }
                }
            }
            es = get_es()
            index = es_index_adapt(
                index_prefix=settings.ES_INDEX_PREFIX,
                doc_type='tractate',
                rw='read'
            )
            res = es.search(
                index=index,
                doc_type='tractate',
                timeout=settings.ES_SEARCH_TIMEOUT,
                body=q,
                from_=0,
                size=30)
            result_data = res['hits']['hits']
            logging.info("result_data:%s" % result_data)

            tractate_tag_name_list = list()
            for item in result_data:
                tractate_id = item['_source']['id']
                tractate_tag_name = item['_source']['tractate_tag_name']
                tractate_tag_name_list.append({"id": tractate_id, "tractate_tag_name": tractate_tag_name})

            ###获取每个tag_name的赞的个数
            tag_name_list = dict()
            for i in tractate_tag_name_list:
                id = i.get("id")
                tractate_name = i.get("tractate_tag_name")
                search = Tractate_Keyword.objects.filter(tractate_id=id).values_list("search_num", flat=True)
                logging.info("get tractate_name")
                for j in tractate_name:
                    if j in tag_name_list.keys():
                        tag_name_list[j] += int(search[0])
                    else:
                        tag_name_list[j] = int(search[0])

            item_lists = sorted(tag_name_list.items(), key=lambda x: x[1], reverse=True)
            logging.info("get item_lists:%s" % item_lists)
            if len(item_lists) <= 10:
                redis_client.set(redis_key, json.dumps(item_lists))
            else:
                redis_client.set(redis_key, json.dumps(item_lists[:10]))

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())


@shared_task
def get_query_wiki_card():
    try:
        redis_key_prefix = "doris_wiki:wiki_card_collect"
        redis_client.delete(redis_key_prefix)
        results_collect = CollectWiki.objects.filter(is_online=True).values("id", "name")
        logging.info("get result_collect:%s" % results_collect)
        for item in results_collect:
            all_data_wiki = []
            collect_data_to_redis = dict()
            collect = list(set(CollectItem.objects.filter(collect_id=item["id"], is_online=True).values_list("item")))
            logging.info("get collect:%s" % collect)
            if len(collect) >= 4:
                for id in collect:
                    name = NewItemWiki.objects.filter(id=id[0], is_online=True).values_list("name",
                                                                                            flat=True).first()
                    latest_update = ALSearchRank.objects.latest('update_date').update_date
                    search_results = ALSearchRank.objects.filter(query=name, update_date=latest_update).values_list(
                        "search_cnt", flat=True).first()
                    search_results = search_results if search_results else 0
                    all_data_wiki.append({"id": id[0], "name": name, "search_results": search_results})
                item_lists = sorted(all_data_wiki, key=lambda e: e.__getitem__('search_results'), reverse=True)
                collect_data_to_redis["id"] = item["id"]
                collect_data_to_redis["wiki"] = item_lists
                logging.info("get collect:%s" % collect_data_to_redis)
                redis_client.hset(redis_key_prefix, hashlib.md5(item["name"].encode("utf-8")).hexdigest(),
                                  json.dumps(collect_data_to_redis))
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
