# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from .alpha import Alpha
from ..documents.docstring import DocString

import unittest


code = """
{-# Straight Configuration Alpha Typedef #-}

{- 输入参数 -}
data Params = {
    id: Int -- 帖子ID
}

{- 返回值 -}
data Result = {
    id: Int
    x: Real
    y: Real
}

{-# Straight End #-}
"""


class TestAlpha(unittest.TestCase):

    def test_create(self):
        a = Alpha()

    def test_1(self):
        a = Alpha()

        docstring = DocString(["Alpha", "Test"], code, "你们好啊")

        fd = a.parse(docstring)

        ti = fd.params.typing
        assert {'id': 1} in ti
        assert {} not in ti
        assert {'id': None} not in ti

        to = fd.result.typing
        assert {'id': 1, 'x': 0, 'y': 0} in to
        assert {'id': 1.0, 'x': 0, 'y': 0} not in to
        assert {'id': 1, 'x': 1, 'y': 2.2} in to
