# coding=utf-8
__all__ = ['get_itemwiki', 'get_tag']

from datetime import datetime, timedelta
from .es import tzlc

MIN_TIME = tzlc(datetime.utcfromtimestamp(0))
MAX_TIME = tzlc(datetime.utcfromtimestamp(2147483647))


def get_tag(instance):
    t = instance
    res = {
        'id': t.id,
        'name': t.name,
        'is_online': t.is_online,
        'description': t.description,
    }

    return res


def get_itemwiki(instance):
    i = instance

    res = {
        'id': i.id,
        'item_name': i.item_name,
        'synonym': i.synonym,
        'slogan': i.slogan,
        'fit_people': i.fit_people,
        'is_online': i.is_online,
    }

    return res


def get_area_tag_info(city):
    if not city:
        return {}
    return {
        'city_tag_id': city.tag_id,
        'city_province_tag_id': city.province.tag_id,
        'city_province_country_tag_id': city.province.country.tag_id,
    }


def ignore_exception(exception_tuple, trunk, default):
    try:
        return trunk()
    except exception_tuple:
        return default


def Wiki_keyword(instance):
    i = instance
    res = {
        "id": i.id,
        'wiki_id': i.wiki_id,
        'name': i.get_wiki_id_name(),
        'is_online': i.get_wiki_id_is_online(),
        'wiki_type': i.wiki_type,
        'city_id': i.city_id,
        "visit_num": i.visit_num,
        "rank": i.rank,
        "visit_time": i.visit_time

    }
    return res
