# coding=utf-8
import json

def setup_tracer(request):
    try:
        seqs = json.loads(request.POST['requests'])
        tracer = seqs[0]['environment'].get('trace_context')
    except (KeyError, IndexError, AttributeError, ValueError):
        tracer = None
        
    if not tracer:
        return {
            'service_name': 'gaia',
            'sampled': False,
            'span_name': '*'
        }
    return {
        'service_name': 'gaia',
        'sampled': tracer['sampled'],
        'debug': tracer.get('debug', False),
        'trace_id': tracer['trace_id'],
        'span_id': tracer['span_id'],
        'span_name': seqs[0]['method'],
    }

