# coding=utf-8
from django.core.management import BaseCommand

from api.models.slide import DisplaySite, Slide, SlideToDisplaySite


items = [
    ('0', 'app轮播图'),
    ('1', '小程序轮播图'),
    ('2', 'M站轮播图'),
    ('3', 'PC站轮播图'),
]


class Command(BaseCommand):
    """
    没有轮播图展示位置编辑页面，所以用脚本创建基础数据,
    并绑定已有轮播图数据，做版本兼容
    """

    def handle(self, *args, **kwargs):
        data = DisplaySite.objects.first()
        if not data:
            print('开始处理数据')
            DisplaySite.objects.bulk_create([
                DisplaySite(display_type=item[0]) for item in items])
            # 数据兼容处理
            display_site_ids = DisplaySite.objects.all().values_list('id', flat=True)

            start_id = 1
            while True:
                slide_ids = Slide.objects.filter(id__gte=start_id).order_by('id') \
                    .values_list('id', flat=True)[:100]
                if not slide_ids:
                    break
                for item in display_site_ids:
                    SlideToDisplaySite.objects.bulk_create(
                        [SlideToDisplaySite(slide_id=slide_id, display_site_id=item)
                         for slide_id in slide_ids]
                    )
                start_id += 100
            print('数据兼容处理完成')
            return
        print('基础数据已经存在，不需要创建')
        return
