# coding=utf-8
import datetime
from django.core.management import BaseCommand
from gm_types.gaia import SERVICE_REVIEW_STATUS

from api.models import ServiceRegister, ServiceReviewRecord


class Command(BaseCommand):
    """
    处理一批美购审核的错误数据
    python manage.py add_serviceregister_review_record
    """

    def handle(self, *args, **options):
        list_service = [5250207,
                        5256440,
                        5256442,
                        4984359,
                        5241599,
                        5057094,
                        5256441,
                        5257054,
                        4917862,
                        5259828,
                        5259925,
                        5298944,
                        5210473,
                        5299088,
                        5244878,
                        5244978,
                        5177256,
                        5284359,
                        5244879,
                        5306079,
                        5176450,
                        5306217,
                        5140015,
                        5273267,
                        5269360,
                        5261428,
                        5098352,
                        5306216,
                        4804524,
                        5166222,
                        5299667,
                        5230620,
                        5299773,
                        4589947]
        for item in list_service:
            serviceregister = ServiceRegister.objects.get(service_id=item)
            if ServiceReviewRecord.objects.filter(serviceregister_id=serviceregister.id).count() == 0:
                update_data = u'处理一下老数据的错误.2016-09-08'
                person_id = '5b1b9ab0e9ae11e5aa5700163e000a4a'
                ServiceReviewRecord.objects.create(
                    person_id=person_id,
                    update_data=update_data,
                    serviceregister_id=serviceregister.id,
                    created_time=datetime.datetime.now(),
                    now_review_status=serviceregister.review_status,
                    review_type=SERVICE_REVIEW_STATUS.UNDER_REVIEW
                )
                print serviceregister.id
