# coding:utf-8
from __future__ import unicode_literals

from django.core.management import BaseCommand
from api.models import Order
from api.models.types import ORDER_STATUS, PAYMENT_TYPE


class Command(BaseCommand):

    def handle(self, *args, **options):

        payment_type = [PAYMENT_TYPE.FULL_PAYMENT, PAYMENT_TYPE.PREPAYMENT]
        order_status = [ORDER_STATUS.PAID, ORDER_STATUS.USED, ORDER_STATUS.SETTLED, ORDER_STATUS.AUDITING,
                        ORDER_STATUS.SETTLING]

        orders = Order.objects.filter(status__in=order_status, service__payment_type__in=payment_type)
        print orders.count()
        for order in orders:
            try:
                order.diary
            except:
                order.create_diary()
