# coding=utf-8

# coding=utf-8
import re

import tablib
from django.core.management import BaseCommand
from openpyxl import load_workbook

from api.models import Service


class Command(BaseCommand):
    """
    导出美购的图文详情 python manage.py export_service_data
    """

    def handle(self, *args, **options):

        desc_new = u"""【返现规则】

1.订单验证后，在订单里点击“分享返现”按钮。

2.需完成任务一：订单评价为四星级以上。

3.需完成任务二：完成符合要求的日记。

4.更新术后当天，次日，一周，两周，三周或其他天数等恢复后的文字描述和照片，不少于（返现金额/50+1）次日志分享，每次分享每次清晰照片不少于5张，文字描述不少于50字。

照片要求：
  术前：至少1张，全脸正面、侧面45°、侧面90°
  术后：至少5张（包含医院环境、手术过程、术前后对比、细节照片、各种角度等和手术相关的照片）
        1）脸部项目请提供全脸照片，非脸部项目请提供术后相关部位照片
        2）照片要求无马赛克、无遮挡（私密部位，要求穿内衣（比如隆胸）和四角短裤（比如大腿吸脂）等）
        3）术后分享高清美照，不能模糊不清，美美的照片通过率更高哦~
内容要求：首篇日记文字不少于100字 ，更新日记文字不少于50字（可以写写术前准备的小心情、医院的环境、医生方案很满意、经验分享等等）。
更新的每篇日记都会由管理员审核，可自行查看日记的审核状态，不合格的需要按照要求补齐。

注意：
1）所有日记需本人真实经历，不能抄袭，如被举报查实，将取消一切福利资格；
2）一个商品购买多次，所写日记仅按一次奖励现金；
3）更美免费活动入选的免费模特，所写帖子，不属于此活动范围；
4）注射、激光等微整项目，发帖满一个月即可申请返现；手术类项目，发帖满三个月才可以申请返现。

PS：请协助医生进行美购验证哦，订单验证后才会有“分享返现”的通道。

5.完成提示篇数的日记都获得通过就可以私信“返现小助手”进行返现，若合格小助手会将（更美价*5%）元现金返还至用户支付账户。本平台可返现金额不高于用户实际支付金额。当用户实际支付金额低于返现金额时，按照实际支付金额进行返现。



特别提示：

1）更美返现给用户，则视为用户同意独家授权本组内容的肖像权给予更美平台，相关发帖内容用户不得自行删除。

2）在不违反现行法律、法规要求前提下，本活动规则由更美APP及项目医院进行说明。"""

        wb = load_workbook(filename='service.xlsx')
        sheetnames = wb.get_sheet_names()
        ws = wb.get_sheet_by_name(sheetnames[0])
        desc = []
        list_result = []
        for rx in range(1, ws.get_highest_row() + 1):
            value = ws.cell(row=rx, column=1).value
            if value:
                services = Service.objects.filter(detail_description__contains=value)
                for service in services:
                    print service.id
                    old_value = service.detail_description
                    # service.detail_description = service.detail_description.replace(value, desc_new)
                    # service.save()
                    list_result.append([
                        service.id,
                        old_value,
                        service.detail_description])

        print len(list_result)

        count = len(list_result)
        begin = 0
        step = 1000
        while begin <= count:
            dt1 = tablib.Dataset()
            dt1.headers = [u'id', u'description', u'description_new']
            for service in list_result[begin:begin + step]:
                dt1.append(service)
            open(u'/data/美券图文详情{0}.xlsx'.format(begin), 'wb').write(dt1.xlsx)
            begin += 1000
