# coding=utf-8
import tablib
from django.core.management import BaseCommand

from api.models import Service


class Command(BaseCommand):
    """
    python manage.py export_serviceitem
    """

    def handle(self, *args, **options):
        file_log = open('service.txt', 'r')
        dt1 = tablib.Dataset()
        dt1.headers = [u'美购ID', u'美购名称', u'多属性ID', u'多属性名称', u'更美价', u'预付款', u'抽成', u'返现', u'美购是否支持随时退款']
        for line in file_log:
            try:
                service_id = int(line)
                service = Service.objects.get(id=service_id)
                for item in service.items.filter(is_delete=False):
                    row = []
                    row.append(service.id)
                    row.append(service.name)
                    row.append(item.id)
                    row.append(''.join(item.items_name))
                    row.append(item.gengmei_price)
                    row.append(item.pre_payment_price)
                    row.append(item.discount)
                    row.append(item.cash_back_fee)
                    row.append(service.refund_anytime)
                    dt1.append(row)
                    print item.id
            except Exception as e:
                print e.message
                continue
        open(u'service_item.xlsx', 'wb').write(dt1.xlsx)
        file_log.close()
        print (u"导出成功!!")
