# coding=utf-8
import tablib
from django.core.management import BaseCommand
from openpyxl import load_workbook

from api.models import ServiceItem


class Command(BaseCommand):
    """
    python manage.py change_price_1111_1  special_id
    """

    def handle(self, *args, **options):
        wb = load_workbook(filename='service_new.xlsx')
        sheetnames = wb.get_sheet_names()
        if sheetnames == 0:
            return
        ws = wb.get_sheet_by_name(sheetnames[0])
        dict_service = []
        for rx in range(2, ws.get_highest_row()):
            try:
                servic_id = int(ws.cell(row=rx, column=1).value)
                servicitem_id = int(ws.cell(row=rx, column=3).value)
                dict_service.append(
                    {
                        'service_id': servic_id,
                        'servicitem_id': servicitem_id,
                        'name': ws.cell(row=rx, column=4).value,
                        'gengmei_price': int(ws.cell(row=rx, column=5).value),
                        'pre_payment_price': int(ws.cell(row=rx, column=6).value),
                        'discount': int(ws.cell(row=rx, column=7).value),
                        'cash_back_fee': int(ws.cell(row=rx, column=8).value),
                        'refund_anytime': bool(ws.cell(row=rx, column=9).value),
                    }
                )
            except Exception as e:
                print e.message
                continue
        print u'数据读取完毕1'
        print len(dict_service)
        wb_old = load_workbook(filename='service_old.xlsx')
        sheetnames_old = wb_old.get_sheet_names()
        if sheetnames_old == 0:
            return
        ws_old = wb_old.get_sheet_by_name(sheetnames_old[0])
        dict_service_old = []
        for rx in range(2, ws_old.get_highest_row()):
            try:
                service_id = int(ws_old.cell(row=rx, column=2).value)
                dict_service_old.append(
                    {
                        'service_id': service_id,
                        'name': ws_old.cell(row=rx, column=6).value,
                        'gengmei_price_new': ws_old.cell(row=rx, column=13).value,
                    }
                )
            except Exception as e:
                print e.message
                continue
        dt_result = tablib.Dataset()
        dt_result.headers = [u'美购ID', u'多属性ID', u'多属性名称', u'更美价', u'预付款', u'抽成', u'返现', u'美购是否支持随时退款',
                             u'修改后的更美价']

        for item_old in dict_service_old:
            lsit_res = []
            for item_new in dict_service:
                if item_new.get('service_id') == item_old.get('service_id') and item_new.get('name') == item_old.get(
                        'name'):
                    if item_new.get('servicitem_id') not in lsit_res:
                        row_service_item = [item_new.get('service_id'), item_new.get('servicitem_id'),
                                            item_new.get('name'),
                                            item_new.get('gengmei_price'), item_new.get('pre_payment_price'),
                                            item_new.get('discount'), item_new.get('cash_back_fee'),
                                            item_new.get('refund_anytime'), item_old.get('gengmei_price_new')]
                        dt_result.append(row_service_item)
                        lsit_res.append(item_new.get('servicitem_id'))

        open(u'result_chuli.xlsx', 'wb').write(dt_result.xlsx)
